#ifndef AVIFILE_AVIMEDIAREADSTREAM_H
#define AVIFILE_AVIMEDIAREADSTREAM_H

#include "Cache.h"
#include "ReadHandlers.h"

class AviMediaReadHandler;

class AviMediaReadStream : public IMediaReadStream
{
friend class AviMediaReadHandler;
protected:
    AviMediaReadHandler* m_pParent;
    AVIStreamHeader m_Header;
    double m_dAvgBytesPerSec;
    mutable StreamInfo m_StreamInfo;
    avm::vector<AVIINDEXENTRY2> m_Index;
    streamid_t m_iId;
    char* m_pcFormat;
    uint_t m_uiFormatSize;
    framepos_t m_uiPosition;
    framepos_t m_uiChunk;
    framepos_t find(framepos_t iSample) const;
public:
    AviMediaReadStream() :m_pParent(0), m_pcFormat(0) {} // for vector
    AviMediaReadStream(AviMediaReadHandler* handler,
		       const AVIStreamHeader& hdr,
                       streamid_t id, char* format, uint_t fsize);
    AviMediaReadStream(const AviMediaReadStream& c);
    virtual ~AviMediaReadStream();

    AviMediaReadStream& operator=(const AviMediaReadStream& c);
    virtual double CacheSize() const;
    virtual void ClearCache();
    virtual uint_t GetHeader(void* pheader, uint_t size) const;
    virtual framepos_t GetPos() const;
    virtual framepos_t GetPrevKeyFrame(framepos_t lFrame = ERR) const;
    virtual framepos_t GetNextKeyFrame(framepos_t lFrame = ERR) const;
    virtual framepos_t GetNearestKeyFrame(framepos_t lFrame = ERR) const;
    virtual framepos_t GetLength() const;
    virtual double GetFrameTime() const;
    virtual double GetLengthTime() const;
    virtual StreamInfo* GetStreamInfo() const;
    virtual double GetSampleTime(framepos_t lSample = ERR) const;
    virtual uint_t GetSampleSize() const { return m_Header.dwSampleSize; }
    virtual fourcc_t GetFourCC() const { return m_Header.fccType; }
    virtual uint_t GetFormat(void *pFormat = 0, uint_t plSize = 0) const;
    virtual bool IsKeyFrame(framepos_t lFrame = ERR) const;
    virtual HRESULT Read(uint_t lSamples, void *lpBuffer, uint_t cbBuffer,
			 uint_t *plBytes, uint_t *plSamples);
    virtual const void* ReadDirect(uint_t* plBytes, uint_t* plSamples);
    virtual HRESULT Seek(framepos_t pos);
    virtual HRESULT SeekTime(double time);
    virtual HRESULT SkipFrame() { return Seek(GetPos()+1); }
    virtual HRESULT SkipTo(double pos) { return SeekTime(pos); }
};

#endif // AVIFILE_AVIMEDIAREADSTREAM_H
