#ifndef AVIFILE_AVIMEDIAREADHANDLER_H
#define AVIFILE_AVIMEDIAREADHANDLER_H

#include "Cache.h"
#include "ReadHandlers.h"

class AviMediaReadStream;

class AviMediaReadHandler : public IMediaReadHandler
{
friend class AviMediaReadStream;
    MainAVIHeader m_MainHeader;
    avm::vector<AviMediaReadStream> m_Streams;
protected:
    InputStream m_Input;
public:
    AviMediaReadHandler(const char* pszFile) throw(FatalError);
    virtual ~AviMediaReadHandler();
    virtual HRESULT GetHeader(void* pheader, uint_t size) const;
    virtual IMediaReadStream* GetStream(fourcc_t fccType, streamid_t id);
    virtual bool GetURLs(avm::vector<avm::string>& urls) const { return false; }
    virtual void Interrupt() {}
    /* avi files are opened synchronously */
    virtual bool IsOpened() const { return true; }
    virtual bool IsValid() const { return true; }
    virtual bool IsRedirector() const { return false; }

    static void PrintMainAVIHeader(const MainAVIHeader& hdr);
    static void PrintAVIStreamHeader(const AVIStreamHeader& hdr);
    static char* GetAviFlags(char* buffer, uint_t flags);

private:
    void checkDword(uint32_t value) throw (FatalError);
    int readMainHeader(uint_t);
    int readStreamHeader() throw(FatalError);
    void readStreams(uint_t);
    // int readMovieChunk();
    int readIndexChunk(uint_t, uint_t movie_chunk_offset);
    int reconstructIndexChunk(uint_t);
};

#endif // AVIFILE_AVIMEDIAREADHANDLER_H
