#ifndef AVIFILE_ASFREDIRECTINPUTSTREAM_H
#define AVIFILE_ASFREDIRECTINPUTSTREAM_H

#include "AsxReader.h"
#include "AsfInputStream.h"

class ASFRedirectInputStream: public ASX_Reader, public ASFInputStream
{
    avm::vector<char> m_Buffer;
public:
    ASFRedirectInputStream(const char* pszFile);
    virtual ~ASFRedirectInputStream(){}
    virtual const MainASFHeader& getHeader() const {return m_Header;}
    virtual const avm::vector<ASFStreamHeader>& getStreams() const { return m_Streams;}
    virtual Iterator* getIterator(int id) {return 0;}

    virtual void interrupt() {}
    virtual double cacheSize() const {return 0.;}
    virtual void clear() {return;}
    virtual bool isOpened() {return true;}
    virtual bool isValid() {return true;}
    virtual bool isRedirector() {return true;}
    virtual bool getURLs(avm::vector<avm::string>& urls) { return ASX_Reader::getURLs(urls);}
};

#endif // AVIFILE_ASFREDIRECTINPUTSTREAM_H
