#include "AsfRedirectInputStream.h"

#include "except.h"

#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>

#define __MODULE__ "ASX redirector parser"

ASFRedirectInputStream::ASFRedirectInputStream(const char* pszFile)
    :m_Buffer(4096)
{
    int fd = open(pszFile, O_RDONLY);
    if (fd < 0)
	throw FATAL("Couldn't open file");
    read(fd, &m_Buffer[0], 4096);
    close(fd);

    if (!ASX_Reader::create(m_Buffer))
	throw FATAL("Not a redirector");
}
