#ifndef ASFREADSTREAM_H
#define ASFREADSTREAM_H

#include "ReadHandlers.h"
#include "StreamInfo.h"
#include "Iterator.h"

class ASFReadHandler;

class ASFReadStream : public IMediaReadStream
{
friend class ASFReadHandler;
protected:
    ASFStreamHeader m_Header;
    ASFReadHandler* m_pParent;
    mutable StreamInfo m_StreamInfo;
    const ASFStreamSeekInfo* m_pSeekInfo;
    int m_iId;
    framepos_t m_uiPosition;
    framepos_t m_uiReadPosition;
    Iterator* m_pIterator;
    int m_iPointer;
    uint_t m_uiSubpointer;
    uint_t m_uiLastTimestamp;
    bool m_bIsAudio;
    bool m_bIsScrambled;
    avm::vector<char> m_pcScrambleBuf;
    bool m_bValidBuf;
    int m_iScrOffset;
    const ASFAudioScrambleDef* m_pScrambleDef;
    ASFReadStream(ASFReadHandler* parent);
public:
    ASFReadStream() :m_pParent(0), m_pSeekInfo(0), m_pIterator(0) {}//for vector
    ASFReadStream(const ASFReadStream& c);
    ASFReadStream& operator=(const ASFReadStream& c);

    virtual ~ASFReadStream();

    virtual uint_t GetHeader(void* pheader = 0, uint_t size = 0) const;
    virtual bool IsKeyFrame(framepos_t lFrame = ERR) const;
    virtual HRESULT Read(uint_t lSamples, void* lpBuffer, uint_t cbBuffer,
			 uint_t* plBytes, uint_t* plSamples);
    // packetized format - packet is reassembled to provided buffer
    // currently asf stream is not precached
    //virtual void* Read(uint_t* plBytes, uint_t* plSamples) { return 0; }
    virtual HRESULT Seek(framepos_t lPos);
    virtual HRESULT SeekTime(double time);
    virtual HRESULT SkipFrame();
    virtual HRESULT SkipTo(double pos);
    virtual double GetFrameTime() const;
    virtual framepos_t GetPos() const;
    virtual framepos_t GetPrevKeyFrame(framepos_t lFrame = ERR) const;
    virtual framepos_t GetNextKeyFrame(framepos_t lFrame = ERR) const;
    virtual framepos_t GetNearestKeyFrame(framepos_t lFrame = ERR) const;
    virtual framepos_t GetLength() const;
    virtual double GetLengthTime() const;
    virtual StreamInfo* GetStreamInfo() const;
    virtual double GetSampleTime(framepos_t frame = ERR) const;
    virtual uint_t GetSampleSize() const;
    virtual uint_t GetFormat(void *format = 0, uint_t size = 0) const;
    virtual void ClearCache();
    virtual double CacheSize() const;
    virtual fourcc_t GetFourCC() const;

protected:
    virtual HRESULT ReadInternal(uint_t lSamples, void* lpBuffer, uint_t cbBuffer,
    				 uint_t* plBytes, uint_t* plSamples);
};

#endif
