#ifndef ASFREADHANDLER_H
#define ASFREADHANDLER_H

#include "default.h"
#include "ReadHandlers.h"
#include "asffmt.h"

class Iterator;
class ASFInputStream;
class ASFStreamSeekInfo;

class ASFReadHandler : public IMediaReadHandler
{
friend class ASFReadStream;
    avm::vector<ASFReadStream> m_Streams;
    avm::vector<const ASFStreamSeekInfo*> m_SeekInfo;
    MainASFHeader m_Header;
protected:
    ASFInputStream* m_pInput;
public:
    ASFReadHandler(const char* pszFile) throw(FatalError);
    virtual ~ASFReadHandler();
    virtual IMediaReadStream *GetStream(fourcc_t fccType, streamid_t id);
    virtual HRESULT GetHeader(void* pheader, uint_t n) const;
    virtual bool GetURLs(avm::vector<avm::string>& urls) const;
    virtual void Interrupt();

    virtual bool IsOpened() const;
    virtual bool IsValid() const;

    virtual bool IsRedirector() const;
};

#endif // ASFREADHANDLER_H
