#define _LARGEFILE64_SOURCE

/// THIS CODE SHOULD BE REWRITTEN TO SOMETHING MORE READABLE
/// FIXME FIXME FIXME

#include "asffmt.h"
#include "AsfReadHandler.h"
#include "AsfReadStream.h"
#include "AsfInputStream.h"
#include "asf_guids.h"

#include <string.h>
#include <stdio.h>

#define __MODULE__ "AsfReaderHandler"
#pragma pack(1)
int ASF_DEBUG=0;
#undef Debug
#define Debug if(ASF_DEBUG)

ASFReadHandler::ASFReadHandler(const char* pszFile) throw(FatalError)
    :m_pInput(ASFInputStream::create(pszFile))
{
    if (!m_pInput)
	throw FATAL("Could not open file");
    m_Header = m_pInput->getHeader();
    const avm::vector<ASFStreamHeader>& str=m_pInput->getStreams();
    for (unsigned i = 0; i < str.size(); i++)
    {
	// FIXME - do this in thread so we could play instantly
	ASFReadStream tmp(this);
	m_Streams.push_back(tmp);
	ASFReadStream& stream=m_Streams.back();
	stream.m_Header=str[i];
	//warning! stream number in packets are 1-based
        // and probably limited by this mask !
	stream.m_iId = stream.m_Header.hdr.stream & 0x7fff;

	stream.m_bIsAudio = GuidIsType(stream.m_Header.hdr.uid_type, GUID_AUDIO_STREAM);
	stream.m_pIterator = m_pInput->getIterator(i);
	stream.m_pSeekInfo = stream.m_pIterator->getSeekInfo();
	stream.m_bIsScrambled = false;
	stream.m_iScrOffset = 0;
	if (stream.m_bIsAudio
	    && GuidIsType(stream.m_Header.hdr.uid_conceal, GUID_AUDIO_CONCEAL_INTERLEAVE))
	{
	    char* ctmp=(char*)(&stream.m_Header.hdr.aud.wfex);
	    ctmp+=18+stream.m_Header.hdr.aud.wfex.cbSize;
	    stream.m_pScrambleDef=(const ASFAudioScrambleDef*)ctmp;
	    //
	    printf("Interleave info: blocksize: %d  chunksize: %d  align: %d",
		   (int)stream.m_pScrambleDef->block_size,
		   stream.m_pScrambleDef->chunk_size,
		   stream.m_pScrambleDef->block_align_1);
	    if ((stream.m_pScrambleDef->block_size!=1)
		&& (stream.m_pScrambleDef->chunk_size/stream.m_pScrambleDef->block_align_1!=1))
	    {
		stream.m_bIsScrambled=true;
		int msize=stream.m_pScrambleDef->chunk_size*stream.m_pScrambleDef->block_size;
		printf(" scrsize: %d", msize);
		stream.m_pcScrambleBuf.resize(msize);
		// stream.m_pcScrambleBuf=new char[msize];
		// stream.m_pcScrambleBuf=(char*)malloc(msize);
	    }
	    printf("\n");
	}
    }
}

ASFReadHandler::~ASFReadHandler()
{
    for (unsigned i = 0; i < m_SeekInfo.size(); i++)
	delete m_SeekInfo[i];
    delete m_pInput;
}

IMediaReadStream* ASFReadHandler::GetStream(fourcc_t fccType, streamid_t id)
{
    guidid_t gid;

    switch (fccType)
    {
    case mmioFOURCC('a', 'u', 'd', 's'):
	gid = GUID_AUDIO_STREAM;
	break;
    case mmioFOURCC('v', 'i', 'd', 's'):
	gid = GUID_VIDEO_STREAM;
        break;
    default:
	return 0;
    }

    streamid_t match = 0;
    for (int i = m_Streams.size()-1; i >= 0; i--)
    {
	if (GuidIsType(m_Streams[i].m_Header.hdr.uid_type, gid))
	{
	    if (match == id)
		return &m_Streams[i];
	    match++;
	}
    }
    return 0;
}

HRESULT ASFReadHandler::GetHeader(void* pheader, uint_t size) const
{
    if (!pheader || (size < sizeof(AVIStreamHeader)))
	return -1;
    memset(pheader, 0, size);

    AVIStreamHeader* p = (AVIStreamHeader*) pheader;

    //cout << "ASFReadHandler::GetHeader()  Not yet fully implemented!" << endl;
    if (!m_Streams.size())
    {
	p->dwRate=15;
	p->dwScale=1;
	p->dwLength=0x7FFFFFFF;
    }
    else
    {
	double stream_length = m_Header.play_time/10000000.;
	p->dwRate=1000000;
	if (m_SeekInfo.size())
	    p->dwScale=1000000/15;
	else
	    p->dwScale=int(1000000*stream_length/m_SeekInfo.size());
	p->dwLength=m_SeekInfo.size();
    }

/*    if (m_bIsAudio)
    {
	p->fccType=mmioFOURCC('a', 'u', 'd', 's');
	p->fccHandler=m_Header.hdr.aud.wfex.wFormatTag;
	p->dwSampleSize=m_Header.hdr.aud.wfex.nBlockAlign;
    }
    else if (m_Header.hdr.uid_type == guid_video_stream)
    {
	p->fccType=mmioFOURCC('v', 'i', 'd', 's');
	p->fccHandler=m_Header.hdr.vid.biCompression;
	p->rcFrame.right=m_Header.hdr.vid.biWidth;
	p->rcFrame.top=m_Header.hdr.vid.biHeight;
    }*/
    return 0;
}

void ASFReadHandler::Interrupt()
{
    return m_pInput->interrupt();
}

double ASFReadStream::CacheSize() const
{
    return m_pParent->m_pInput->cacheSize();
}

bool ASFReadHandler::IsOpened() const
{
    return m_pInput->isOpened();
}

bool ASFReadHandler::IsValid() const
{
    return m_pInput->isValid();
}

bool ASFReadHandler::IsRedirector() const
{
    return m_pInput->isRedirector();
}

bool ASFReadHandler::GetURLs(avm::vector<avm::string>& urls) const
{
    return m_pInput->getURLs(urls);
}

IMediaReadHandler *CreateASFReadHandler(const char *pszFile) throw(FatalError)
{
    return new ASFReadHandler(pszFile);
}
