#ifndef AVIFILE_ASFINPUTSTREAM_H
#define AVIFILE_ASFINPUTSTREAM_H

#include "asffmt.h"
#include "Iterator.h"

/**
    Pure virtual class that hides complications of protocol-specific
    access to ASF media. Will be inherited by ASFFileInputStream
    ( class that implements reading of local ASF files )
    and ASFNetworkInputStream ( class that implements streaming of
    ASF over HTTP ).
**/    

class ASFInputStream
{
protected:
    MainASFHeader m_Header;
    avm::vector<ASFStreamHeader> m_Streams;
public:
    static ASFInputStream* create(const char* pszFile);
    virtual ~ASFInputStream(){}
    virtual const MainASFHeader& getHeader() const =0;
    virtual const avm::vector<ASFStreamHeader>& getStreams() const =0;
    virtual Iterator* getIterator(int id) =0;

    virtual void interrupt() =0;
    virtual double cacheSize() const =0;
    virtual void clear() =0;
//    virtual bool isLocal() =0;
    virtual bool isOpened() =0;
    virtual bool isValid() =0;
    virtual bool isRedirector() =0;
    virtual bool getURLs(avm::vector<avm::string>& urls) =0;
};

#endif // AVIFILE_ASFINPUTSTREAM_H
