#ifndef AVIFILE_ASFFILEINPUTSTREAM_H
#define AVIFILE_ASFFILEINPUTSTREAM_H

#include "Iterator.h"
#include "AsfInputStream.h"
#include "Locker.h"

/**
    Relative complexity of this model serves the following purposes:
    1) Local and remote ASF files should be seekable from player
      ( allow to simultaneously re-seek all streams to the same position ).
    2) Data downloaded from network stream should be cached ( downloaded
    before it's requested ) and discarded when it's not inter needed
    3) Local ASF files should allow independent seeking in streams.
    4) Local ASF files should allow their conversion to AVI to as much
    extent as it is possible.
**/

class ASFFileInputStream: public ASFInputStream
{
friend class FileIterator;
protected:
    int64_t m_lDataOffset;
    int m_iFd;
    int maxStreamId;
    PthreadMutex m_Mutex;
    avm::vector<ASFStreamSeekInfo*> m_SeekInfo;
public:
    ASFFileInputStream(const char* pszFile);
    virtual ~ASFFileInputStream();
//    virtual packet GetPacket(int64_t id, bool& success);
    virtual double cacheSize() const;
    virtual void clear();
    virtual Iterator* getIterator(int id);
    virtual const MainASFHeader& getHeader() const {return m_Header;}
    virtual const avm::vector<ASFStreamHeader>& getStreams() const {return m_Streams;}
    virtual bool getURLs(avm::vector<avm::string>& urls) {return false;}
//    virtual bool isLocal() {return true;}
    virtual void interrupt();
    virtual bool isOpened() {return true;}
    virtual bool isValid() {return true;}
    virtual bool isRedirector() {return false;}
protected:
    void createSeekData();
};

#endif // AVIFILE_ASFFILEINPUTSTREAM_H
