#ifndef AVIFILE_AVIPLAY2_H
#define AVIFILE_AVIPLAY2_H

#include "aviplay_impl.h"

class AviPlayer2: public AviPlayer, public PlayerWidget
{
    PlayerWidget* m_pParent;
    void* m_pDpy;
    int m_iResizeCount;
public:
    AviPlayer2(PlayerWidget*, void*, const char* filename, const char* subname, const char* vcodec, const char* acodec) throw(FatalError);
    virtual ~AviPlayer2();
    virtual void CreateVideoRenderer(bool useyuv);
    virtual int Refresh();
    virtual int Resize(int& new_w, int& new_h);
    virtual void UpdateResize();
    virtual int ToggleFullscreen(bool maximize=false);

    // FIXME: will be removed - and replaced with better code later
    // this is very impractical
    // we need to support many other callbacks
    // users might want to use any device they have connected
    // to their linux to control player
    virtual void PW_showconf_func(); //double-click
    virtual void PW_stop_func(); //'x'
    virtual void PW_middle_button(); //middle-click
    virtual void PW_pause_func();//'c'
    virtual void PW_play_func(); //'v'
    virtual void PW_quit_func(); //'q'
    virtual void PW_menu_slot(); //right-click
    virtual void PW_key_func(int sym, int mod); //right-click
    virtual void PW_fullscreen();//alt+enter, esc
    virtual void PW_resize(int w, int h); // resize event
    virtual void PW_refresh();
    virtual void PW_maximize_func();
protected:
    virtual int setUseYUV(bool enable);
    virtual int setFont(const char* fn);
    static void drawFunc(const CImage*, void* arg=0);
    static void killHandler(int, void* arg=0);
};

#endif // AVIFILE_AVIPLAY2_H
