#ifndef AVIFILE_STATISTIC_H
#define AVIFILE_STATISTIC_H

#define STAT_SIZE 25

#include "default.h"
#include "avm_stl.h"
#include "except.h"

class Statistic
{
    avm::string m_pName;
    float* m_pValues;
    uint_t m_uiSize;
    uint_t m_uiPos;
    double m_dSum;

public:
    explicit Statistic(const char* name, uint_t msize = STAT_SIZE) throw(FatalError);
    Statistic(const Statistic& s);
    ~Statistic();

    float average() const;
    void insert(float v);
    const char* getName() const;
};

#endif // AVIFILE_STATISTIC_H
