
#include "Statistic.h"
#include <string.h>
//#include <iostream>

#define __MODULE__ "IAviPlayer"

//using namespace std;

Statistic::Statistic(const char* name, uint_t size) throw(FatalError)
    :m_pName(name), m_pValues(0), m_uiSize(size), m_uiPos(0), m_dSum(0)
{
    if (m_uiSize <= 0)
	throw FATAL("Statistic size <0 is not allowed");
}

Statistic::Statistic(const Statistic& s)
{
    m_pName = s.m_pName;
    m_uiSize = s.m_uiSize;
    m_pValues = new float[m_uiSize];
    memcpy(m_pValues, s.m_pValues, sizeof(float) * m_uiSize);
    m_dSum = s.m_dSum;
    m_uiPos = s.m_uiPos;
}

Statistic::~Statistic()
{
    delete[] m_pValues;
}

void Statistic::insert(float v)
{
    if (!m_pValues)
    {
	m_pValues = new float[m_uiSize];
	for (unsigned i = 0; i < m_uiSize; i++)
	    m_pValues[i] = v;
        m_dSum = v * (m_uiSize);
    }

    m_dSum -= m_pValues[m_uiPos];
    m_pValues[m_uiPos] = v;
    m_dSum += v;

    m_uiPos = (m_uiPos + 1) % m_uiSize;

    //cout << "Insert " << v << "  s: " << m_dSum << "  p: " << m_uiPos << endl;
}


float Statistic::average() const
{
    return m_dSum / m_uiSize;
}

const char* Statistic::getName() const
{
    return (const char*) m_pName;
}
