#ifndef AVIFILE_SDLAUDIORENDERER_H
#define AVIFILE_SDLAUDIORENDERER_H

#include "IAudioRenderer.h"
#include "AudioQueue.h"

#ifdef USE_SDL

#include <SDL.h>
#include <SDL_audio.h>

class SdlAudioMix : public IAudioMix
{
    int m_iVolume;
public:
    SdlAudioMix();
    virtual void Mix(void* data, const void* src, uint_t n) const;
    void SetVolume(float volume = 1.0)
    {
	m_iVolume = int(SDL_MIX_MAXVOLUME * volume);
    }
};

class SdlAudioRenderer: public IAudioRenderer
{
public:
    SdlAudioRenderer(IAviReadStream* astream, WAVEFORMATEX& m_Owf,
		     uint_t useFreq = 0, const char* cname = 0);
    ~SdlAudioRenderer();
    virtual HRESULT SetVolume(float volume);
protected:
    virtual void pause(int v);
    // C binding - used for SDL callback
private:
    static void fillAudio(void* userdata, unsigned char* stream, int len);

    SDL_AudioSpec m_Spec;
    SdlAudioMix m_Audiomix;
    Uint32 sdl_systems;
    double m_dSpecTime;
    uint_t m_uiUseFreq;
};

#endif // USE_SDL
#endif // AVIFILE_SDLAUDIORENDERER_H
