#include "SdlAudioRenderer.h"

#ifdef USE_SDL

#include "avifile.h"
#include "except.h"
#include "cpuinfo.h"
#include "utils.h"

#include <string.h>
#include <stdlib.h>
#include <math.h>

#undef Debug
#define Debug if(0)

#define __MODULE__ "SdlAudioRenderer"

//#define USE_ALOCK

SdlAudioRenderer::SdlAudioRenderer(IAviReadStream* as, WAVEFORMATEX& Owf,
				   uint_t useFreq = 0, const char* privcname = 0)
    :IAudioRenderer(as, Owf, privcname), m_uiUseFreq(useFreq)
{
    try
    {
	sdl_systems = 0;
	Uint32 subsystem_init = SDL_WasInit(SDL_INIT_EVERYTHING);

	if (subsystem_init == 0)
	{
	    SDL_Init(SDL_INIT_NOPARACHUTE);
	    atexit(SDL_Quit);
	}
	if (!(subsystem_init & SDL_INIT_AUDIO))
	{
	    if (SDL_InitSubSystem(SDL_INIT_AUDIO) < 0)
		throw FATAL("Failed to init SDL_AUDIO");
            sdl_systems |= SDL_INIT_AUDIO;
	}

	SDL_AudioSpec spec;
	spec.freq = (useFreq) ? useFreq : m_Owf.nSamplesPerSec;
	spec.format = (m_Owf.wBitsPerSample == 16) ? AUDIO_S16 : AUDIO_U8;
	spec.channels = m_Owf.nChannels;
	spec.samples = (spec.freq >= 32000) ? 4096 : 2048;
	// shorter buffer generates more interrupts
	// and would give us more precise timing -
	// on the other hand it's more sensitive to the system load
        // for slowly moving sound - shorter buffer is better
	spec.callback = fillAudio;
	spec.userdata = this;

	// to simulate broken audio card
	// spec.freq += -1000;

	if (SDL_OpenAudio(&spec, &m_Spec) < 0)
	    throw FATAL("Couldn't open audio device: %s", SDL_GetError());

#ifdef USE_ALOCK
	SDL_PauseAudio(0);
	SDL_LockAudio();
#endif
	Debug printf("SdlAudioRenderer: Error: %s\n", SDL_GetError());
	m_fAsync = 0.0f;
	m_dSpecTime = m_Spec.size/(double) m_pQueue->GetBytesPerSec();
	//cout << "SpecTime: " << m_Spec.freq << "  " << m_dSpecTime << endl;
	Debug printf("SdlAudioRenderer: audio buffer size: %d  freq: %d", m_Spec.size, m_Spec.freq);
    }
    catch (FatalError& error)
    {
	m_pAudiostream = 0;
	throw;
    }
}

SdlAudioRenderer::~SdlAudioRenderer()
{
    Debug printf("SdlAudioRenderer: Destroy()\n");
    m_bQuit = true;
    m_bInitialized = false;
    m_pQueue->Broadcast();
#ifdef USE_ALOCK
    cout << "Destr audio" << endl;
    SDL_UnlockAudio();
#endif
    SDL_CloseAudio();
    SDL_QuitSubSystem(sdl_systems);
    Debug printf("SdlAudioRenderer: Destroy() successful\n");
}

void SdlAudioRenderer::fillAudio(void* userdata, unsigned char* stream, int len)
{
    Debug printf("SdlAudioRenderer: fillAudio()\n");

    if (!userdata)
	return;

    SdlAudioRenderer& a = *(SdlAudioRenderer*)userdata;

    while (!a.m_bQuit && a.m_bInitialized && !a.m_bPaused)
    {
	if (a.m_pQueue->GetSize() < unsigned(len))
	{
	    if (a.m_pAudiostream->Eof())
	    {
		memset(stream, 0, len);
                len = a.m_pQueue->GetSize();
                if (len == 0)
		    break;
                continue;
	    }
	    //Debug cout<<"SdlAudioRenderer: waiting: size "<<a.m_pQueue->GetSize()<<", len "<<len<<endl;
	    //cout << "wait" << endl;
	    a.m_pQueue->Lock();
	    if (a.m_pQueue->GetSize() < unsigned(len)
		&& !a.m_bQuit && a.m_bInitialized && !a.m_bPaused)
		a.m_pQueue->Wait();
	    a.m_pQueue->Unlock();
	    continue;
	}

	if (a.m_lTimeStart > 0)
	{
	    double nt = a.m_pAudiostream->GetTime() - a.GetBufferTime() - a.m_fAsync;
	    if (nt < 0.0)
                nt = 0.0;
	    double st = a.GetTime();
	    double dt = st - nt;
	    double df = 0.08;//3000.0 / a.m_Owf.nSamplesPerSec;
	    //cout << "****stime " << nt << "  " << st << "   " << dt << " t:" << a.m_pAudiostream->GetTime() << "  b:" << a.GetBufferTime() << "  " << df << endl;
	    if (dt > df || dt < -df)
	    {
		// we need bigger jump when sound is going slower!
		//cout << "add " << ((dt > 0) ? -0.02 : 0.01) << "   " << df << endl;
		a.m_dAudioRealpos += (dt > 0) ? -0.02 : 0.01;
	    }
	}

#if 0
	static int64_t las = 0;
	int64_t tlas = longcount();
	cout << "diff    " << to_float(tlas, las) << endl;
        las = tlas;
#endif
	a.m_pQueue->Read((char*)stream, len, &a.m_Audiomix);

	int64_t ct = longcount();
	if (a.m_dPauseTime > 0)
	{
	    a.m_lTimeStart += ct - a.m_lAudioTime;
	    //Debug cout << "Restart after Pause" << endl;
	    if (to_float(ct, a.m_lAudioTime) > a.m_dSpecTime)
	    {
		//cout << "PAUSE fix  " << to_float(ct, a.m_lAudioTime) << endl;
		a.m_dAudioRealpos += a.m_dSpecTime;
	    }
            a.m_dPauseTime = 0.0;
	}
	a.m_lAudioTime = ct;
	if (a.m_lTimeStart == 0)
	{
	    a.m_lTimeStart = ct;
	    //a.m_dAudioRealpos -= a.m_dSpecTime;
#if 0
	    SDL_AudioSpec spec;
	    spec.freq = (a.m_uiUseFreq) ? a.m_uiUseFreq : a.m_Owf.nSamplesPerSec;
	    spec.format = (a.m_Owf.wBitsPerSample == 16) ? AUDIO_S16 : AUDIO_U8;
	    spec.channels = a.m_Owf.nChannels;
	    printf("OLDAUDIO  freq:%d  format:%d  channels:%d\n",
		   a.m_Spec.freq, a.m_Spec.format, a.m_Spec.channels);

	    printf("NEWAUDIO  freq:%d  format:%d  channels:%d\n",
		   spec.freq, spec.format, spec.channels);
#endif
	}
#if 0
	// some gcc compiler doesn't like to compile int64 output for ostream
        // we don't need this code so its commented out
	Debug
	{
	    static uint64_t mylast = 0;
	    float dd = to_float(longcount(), mylast);
	    mylast = longcount();
	    cout << "SdlAudioRenderer: after read: stream pos " << a.m_pAudiostream->GetTime()
		<< ", async " << a.m_fAsync
		<< ", spec_size " << a.m_Spec.size
		<< ", m_pQueue " << a.m_pQueue->size()
		<< ", realpos " << a.m_dAudioRealpos
		<< ", channels " << a.m_Owf.nChannels
		<< ", bitspersample " << a.m_Owf.wBitsPerSample
		<< ", persec " << a.m_Owf.nSamplesPerSec
		<< endl;
	}
#endif
	break;
    }
}

void SdlAudioRenderer::pause(int v)
{
#ifdef USE_ALOCK
    //cout << "PAUSE " << v << endl;
    if (v)
	SDL_LockAudio();
    else
    {
	m_lTimeStart += (longcount() - m_lAudioTime);
	SDL_UnlockAudio();
    }
    //cout << "PAUSE done" << endl;
#else
    SDL_PauseAudio(v);
#endif
}

HRESULT SdlAudioRenderer::SetVolume(float volume)
{
    HRESULT hr = IAudioRenderer::SetVolume(volume);
    if (hr == 0)
	m_Audiomix.SetVolume(m_fVolume);
    return hr;
}

// SdlAudioMix implementation

SdlAudioMix::SdlAudioMix()
{
    SetVolume();
}

void SdlAudioMix::Mix(void* data, const void* src, uint_t n) const
{
    // SDL is broken here - it really should use const pointer for src
    if (m_iVolume != SDL_MIX_MAXVOLUME)
	SDL_MixAudio((Uint8*) data, (Uint8*) src, n, m_iVolume);
    else
	memcpy(data, src, n);
}

#endif // USE_SDL
