#ifndef AVIFILE_OSSAUDIORENDERER_H
#define AVIFILE_OSSAUDIORENDERER_H

#include "IAudioRenderer.h"

#ifdef OSS_SUPPORT

class OssAudioRenderer: public IAudioRenderer
{
public:
    OssAudioRenderer(IAviReadStream* stream, WAVEFORMATEX& Owf, const char* cname=0);
    ~OssAudioRenderer();

protected:
    virtual void reset();
    static void* doAudioOut(void* arg);
    virtual double getRendererBufferTime() const;
    				// length of sound in OSS buffer

    int m_iAudioFd;		// /dev/dsp or ESD socket ( syntactically the same behaviour )
    unsigned m_iSndLimit;	// DMA buffer size
    int m_iDebugStatus; 	// used for debugging console output
    mutable int m_iDelayMethod;
    PthreadTask* m_AudioThread;	// Writes data to audio_fd
};

#endif // OSS_SUPPORT
#endif // AVIFILE_OSSAUDIORENDERER_H
