/*********************************************************

	DSP OssAudioRenderer implementation

*********************************************************/

#include "OssAudioRenderer.h"

#ifdef OSS_SUPPORT

#include "AudioQueue.h"
#include "RegAccess.h"
#include "avifile.h"
#include "except.h"
#include "cpuinfo.h"
#include "utils.h"

#ifdef __NetBSD__
#include <soundcard.h>
#else
#include <sys/soundcard.h>
#endif

#include <sys/ioctl.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>

#define __MODULE__ "OssAudioRenderer"

#define Debug if(0)

#ifndef AFMT_AC3
#define AFMT_AC3 0x400
#endif

OssAudioRenderer::OssAudioRenderer(IAviReadStream* as, WAVEFORMATEX& Owf, const char* privcname)
    :IAudioRenderer(as, Owf, privcname), m_iAudioFd(-1), m_iDelayMethod(2)
{
    try
    {
	try
	{
	    //m_iAudioFd = open("/dev/dsp", O_RDWR);
	    m_iAudioFd = open("/dev/dsp", O_WRONLY);
	    //m_iAudioFd = open("/dev/dsp", O_WRONLY | O_NDELAY);
	    if (m_iAudioFd < 0)
  		throw FATAL("Can't open audio device");

	    int flag = fcntl(m_iAudioFd, F_GETFL, 0);
	    if (flag < 0)
		throw FATAL("fcntl");
	    //flag &= ~O_NDELAY;
	    //if (fcntl(m_iAudioFd, F_SETFL, flag) < 0)
	    //    throw FATAL("fcntl");
	}
	catch (FatalError& e)
	{
	    //e.PrintAll();
	    if (m_iAudioFd > 0)
		::close(m_iAudioFd);
	    m_iAudioFd = open("/dev/dsp", O_WRONLY);
	}
        if (m_iAudioFd < 0)
     	    throw FATAL("Can't open audio device");

	//cout << "Format " << m_Owf.wFormatTag << endl;
	if (m_Owf.wFormatTag == 0x2000)
	{
            // AC3 passthrough support
	    int tmp = AFMT_AC3;
	    if (ioctl(m_iAudioFd, SNDCTL_DSP_SETFMT, &tmp) < 0 || tmp != AFMT_AC3)
		throw FATAL("AC3 SNDCTL_DSP_SETFMT failed\n** Have you set emu10k1 "
			    "into proper state?? (see README) **");
	    else
		printf("AC3 pass-through enabled\n");
	}
	else
	{
            int tmp;
	    //ioctl(m_iAudioFd, SNDCTL_DSP_RESET, 0);

	    //tmp = 1;
	    //ioctl(m_iAudioFd, SNDCTL_DSP_SETFMT, &tmp);

	    tmp = m_Owf.nChannels-1;
	    if (ioctl(m_iAudioFd, SNDCTL_DSP_STEREO, &tmp) != 0)
		throw FATAL("ioctl(stereo)");

	    tmp = m_Owf.wBitsPerSample;
	    if (ioctl(m_iAudioFd, SNDCTL_DSP_SAMPLESIZE, &tmp) < 0)
		throw FATAL("ioctl(samplesize)");

	    tmp = m_Owf.nSamplesPerSec;
#if 0
	    static const int supportedFreq[] =
	    {
		8000, 11025, 16000, 22050, 24000, 32000, 44100, 48000, 0
	    };

	    int i;
	    for (i = 0; supportedFreq[i]; i++)
	    {
		if (tmp <= supportedFreq[i])
		{
		    tmp = supportedFreq[i];
		    break;
		}
	    }
	    if (!supportedFreq[i])
		tmp = 44100; // default;
	    //tmp = 18755;
	    if (tmp != m_Owf.nSamplesPerSec)
		cout << "For playing using frequency " << tmp
		    << "Hz instead of unsupported "
		    << m_Owf.nSamplesPerSec << "Hz as you wish" << endl;
#endif
	    if (ioctl(m_iAudioFd, SNDCTL_DSP_SPEED, &tmp) != 0)
		throw FATAL("ioctl(speed)");

	    audio_buf_info zz;
	    ioctl(m_iAudioFd, SNDCTL_DSP_GETOSPACE, &zz);
	    m_iSndLimit = zz.bytes;
	    //cout << "m_iSndLimit " << m_iSndLimit << endl;
	}

	printf("OSS audio renderer initialized\n");
    }
    catch (FatalError& error)
    {
	if (m_iAudioFd > 0)
	    ::close(m_iAudioFd);
	throw;
    }

    m_AudioThread = new PthreadTask(0, doAudioOut, (void*)this);
}

OssAudioRenderer::~OssAudioRenderer()
{
    Debug printf("Destroying Oss Audio Renderer\n");
    m_bQuit = true;
    m_pQueue->Broadcast();
    delete m_AudioThread;
    ::close(m_iAudioFd);
}

void* OssAudioRenderer::doAudioOut(void* arg)
{
    OssAudioRenderer& a = *(OssAudioRenderer*)arg;
    double skiptime = 0.0;
    while (!a.m_bQuit)
    {
	if (a.m_bPaused)
	{
	    //cout << "pausetm " << a.m_dPauseTime << endl;
	    a.m_dAudioRealpos += a.getRendererBufferTime();
            int i = 50;
	    while (a.m_Owf.wFormatTag == 0x01 // only for PCM sound
		   && i--	            // might be broken driver...
		   && !a.m_bQuit
		   && (a.m_bPaused || a.getRendererBufferTime() > 0))
		avm_usleep(10000);
	    continue;
	}

	static int reset_dev = 0;
	if (!a.m_bInitialized)
	{
            //cout << "RESET UNINT" << endl;
	    if (reset_dev)
	    {
		a.m_pQueue->Clear();
		a.reset();
		reset_dev = 0;
	    }
	    avm_usleep(10000);
	    // cout<<"Not m_bInitialized"<<endl;
	    continue;
	} else
	    reset_dev=1;

	audio_buf_info zz;
	ioctl(a.m_iAudioFd, SNDCTL_DSP_GETOSPACE, &zz);
	//cout << "ospace " << zz.bytes << "  " << zz.fragments*zz.fragsize
	//    << "  frag " << zz.fragments << "  fsize " << zz.fragsize << endl;
	if (zz.fragments * zz.fragsize == 0)
	{
	    // check if there is space for new fragment
	    //
	    // Note: doesn't work for AC3 streams with EMU10K1
            //
	    avm_usleep(10000);
	    //Debug cout<<"Buffer full"<<endl;
	    continue;
	}

	a.m_pQueue->Lock();
	//cout << "bsz : " << a.m_pQueue->GetBufferTime() << endl;
	if (a.m_pQueue->GetSize() < 8192)
	{
	    a.m_pQueue->Wait();
	    a.m_pQueue->Unlock();
	    continue;
	}
	a.m_pQueue->Unlock();

	if (a.m_lTimeStart > 0)
	{
	    double nt = a.m_pAudiostream->GetTime() - a.GetBufferTime() - a.m_fAsync;
	    if (nt < 0.0)
                nt = 0.0;
	    double st = a.GetTime();
	    double dt = st - nt;
	    double df = 0.08;//3000.0 / a.m_Owf.nSamplesPerSec;
	    //printf("****stime %f  %f  %f   t: %f   b: %f   df: %f\n", nt, st, dt,
	    //       a.m_pAudiostream->GetTime(), a.GetBufferTime(), df);
	    if (dt > df || dt < -df)
	    {
		// we need bigger jump when sound is going slower!
		//printf("add  %f   %f\n", ((dt > 0) ? -0.02 : 0.01), df);
		a.m_dAudioRealpos += (dt > 0) ? -0.02 : 0.01;
	    }
	}

	//cout<<"Buffer fullness   "<< zz.bytes << endl;
/*	cout<<">"<<a.m_pAudiostream->GetTime()<<" "<<a.bufferTime()
		<<" "<<" -> "<<a.m_pAudiostream->GetTime()-a.bufferTime()
	        <<" "<<longcount()/550000000.<<endl;*/
	//float in=a.getTime();
	//int64_t ts=longcount();
//	cout<<"Before: "<<in<<endl;

	int result = a.m_pQueue->Write(a.m_iAudioFd);

	//cout << "Wrote " << result << " bytes" << endl;
	if (result == 0 || (result < 0 && errno == EAGAIN))
	    avm_usleep(10000);
	else if (result < 0)
	    perror("AudioQueue::write");
	else
	{
	    int64_t ct = longcount();
	    if (a.m_dPauseTime > 0 && !a.m_bPaused)
	    {
		a.m_lTimeStart += ct - a.m_lAudioTime;
		a.m_dPauseTime = 0.0;
	    }
	    a.m_lAudioTime = ct;

	    if (a.m_lTimeStart == 0)
		a.m_lTimeStart = ct;
	    //a.m_dAudioRealpos = a.m_pAudiostream->GetTime() - a.GetBufferTime();

	    //	    cout<<a.m_pAudiostream->GetTime()<<" "<<frame_time
	    //		<<" "<<" -> "<<a.m_dAudioRealpos
	    //	        <<" "<<longcount()/550000000.<<endl;
	    //float out=a.getTime();
	    //int64_t tx=longcount();
	    //	    cout<<"Write mismatch: "<<1000.*(out-in)-to_float(tx,ts)
	    //	    <<" ms ( writing "<<to_float(tx,ts)<<" ms, stream difference "<<1000.*(out-in)<<" ms )"<<endl;
	}
    }

    Debug printf("OssAudioRenderer: audio thread finished\n");
    return 0;
}

void OssAudioRenderer::reset()
{
    //cout << "RESET " << endl;
    if (0 && m_iAudioFd)
	ioctl(m_iAudioFd, SNDCTL_DSP_RESET, NULL);
}

double OssAudioRenderer::getRendererBufferTime() const
{
    if (m_Owf.wFormatTag != 0x01 || m_lTimeStart == 0)
        return 0.0; // to be solved - problems with SBLive and AC3

    //cout << m_pQueue->GetSize() << "  at "
    //    <<  m_lAudioTime << "   ts " <<  m_lTimeStart << endl;

    audio_buf_info zz;
    int r;
    switch (m_iDelayMethod)
    {

    case 2:
#ifdef SNDCTL_DSP_GETODELAY
	if (ioctl(m_iAudioFd, SNDCTL_DSP_GETODELAY, &r)!=-1)
	    break;
#endif
	m_iDelayMethod--; // fallback if not supported
    case 1:
	if (ioctl(m_iAudioFd, SNDCTL_DSP_GETOSPACE, &zz)!=-1)
	{
	    r = m_iSndLimit - zz.bytes;
            break;
	}
	m_iDelayMethod--; // fallback if not supported
    default:
	r = m_iSndLimit; // full buffer
    }
    //printf("GETRENDER %f   %d  %d\n", r / (double) m_pQueue->GetBytesPerSec(),
    //       r, m_pQueue->GetBytesPerSec());
    return r / (double) m_pQueue->GetBytesPerSec();
}

#endif // OSS_SUPPORT
