#ifndef AVIFILE_IAUDIORENDERER_H
#define AVIFILE_IAUDIORENDERER_H

#include "default.h"
#include "formats.h"
#include "Locker.h"

class AudioQueue;
class IAviReadStream;

class IAudioRenderer
{
public:
    IAudioRenderer(IAviReadStream* astream, WAVEFORMATEX& m_Owf, const char* privname=0);
    virtual ~IAudioRenderer();
    virtual void Clear();		//remove all data from buffers
    virtual bool Eof() const;
    virtual int Extract(double);
    virtual double GetBufferTime() const;//for how long we can play without Extract()'s?
    virtual double GetCacheSize() const;
    virtual const char* GetAudioFormat() const;
    virtual double GetLengthTime() const;
    virtual double GetTime();
    virtual HRESULT Pause(bool state);      // 0 - Ok   -1 - ignored
    virtual HRESULT Reseek(double pos);
    virtual void SetAsync(float async);
    virtual HRESULT SetPlayingRate(int rate);
    virtual HRESULT SetResamplingRate(int rate);
    virtual HRESULT SetVolume(float volume);
    virtual HRESULT Skip(double);
    virtual void Start();
    virtual void Stop();
    virtual void Wake();		// restart thread if it waits
protected:
    virtual void pause(int);
    virtual void reset();
    virtual double getRendererBufferTime() const { return 0.0; }

    IAviReadStream* m_pAudiostream;
    AudioQueue* m_pQueue; 	// using pointer - faster gcc3.0 compilation
    PthreadMutex m_Mutex;
    bool m_bQuit;		// true when terminating thread
    bool m_bPaused;		// true if we are paused
    bool m_bInitialized;	// true if we are playing OR paused
    int64_t m_lTimeStart;	// Timestamp of start
				// updated after each reseek or pause
    int64_t m_lAudioTime;	// Timestamp of last write to audio_fd
    double m_dAudioRealpos;	// Precise position of audio at audio_time
    double m_dPauseTime;	// Timestamp at pause

    char m_pcAudioDesc[100];
    WAVEFORMATEX m_Iwf;		// Input format of data we get from the audiostream
    WAVEFORMATEX m_Owf;		// Resulting Output format of data

    float m_fVolume;
    float m_fAsync;		// by default 0, hardware-dependent
    char* m_pcLocalFrame;	// audio LocalFrame
};

#endif // AVIFILE_IAUDIORENDERER_H
