/*********************************************************

	CopyAudioRenderer implementation

*********************************************************/

#include "aviplay.h" // AUDIOFUNC
#include "CopyAudioRenderer.h"
#include "AudioQueue.h"
#include "avifile.h"
#include "utils.h"

#define __MODULE__ "CopyAudioRenderer"

CopyAudioRenderer::CopyAudioRenderer(IAviReadStream* stream, WAVEFORMATEX& Owf, AUDIOFUNC func, void* arg, const char* cname)
    : IAudioRenderer(stream, Owf, cname)
{
    m_pAudiostream = stream;
    m_pAf = func;
    m_pArg = arg;
}

int CopyAudioRenderer::Extract(double val)
{
    IAudioRenderer::Extract(val);

    m_lAudioTime = longcount();

    int size = m_pQueue->GetSize();

    m_dAudioRealpos = m_pAudiostream->GetTime()
	- m_pQueue->GetBufferTime() - m_fAsync;

    if (m_bInitialized && !m_bPaused && size > 8192)
    {
	char temp[size];

	m_pQueue->Read(temp, size);

	int ok = m_pAf(temp, size, m_pArg);
	if (ok < size)
	    m_pQueue->Unread(size - ok);
    }
    return 0;
}
