#ifndef AVIFILE_AUDIOQUEUE_H
#define AVIFILE_AUDIOQUEUE_H

#include "default.h"
#include "formats.h"
#include "Locker.h"

class IAudioResampler;
class IAudioCleaner;

class IAudioMix
{
public:
    virtual void Mix(void* data, const void* src, uint_t n) const = 0;
};

class AudioQueue
{
public:
    AudioQueue(WAVEFORMATEX& Iwf, WAVEFORMATEX& Owf);
    ~AudioQueue();
    void Clear();
    void DisableCleaner();
    double GetBufferTime() const { return GetSize() / (double) m_uiBytesPerSec; }
    uint_t GetBytesPerSec() const { return m_uiBytesPerSec; }
    int Push(const void* data, uint_t count);
    int Read(void* data, uint_t count, const IAudioMix* amix = 0);
    uint_t Resample(void* dest, const void* src, uint_t src_size);
    uint_t GetSize() const { return m_uiFrameSize; }
    int Write(int fd);
    int Unread(uint_t count);

    int Broadcast();
    int Wait() { return m_Cond.Wait(m_Mutex); }
    int Lock() { return m_Mutex.Lock(); }
    int Unlock() { return m_Mutex.Unlock(); }
protected:
    static const float BUFFER_TIME = 1.5; // buffer 1.5 seconds

    uint_t AUDIO_BUFFER_SIZE; // modified to AC3 packet size for AC3 passthough
    PthreadCond m_Cond;      	// Broadcast to notify audio_thread about
				// new available data OR about quit=1

    PthreadMutex m_Mutex;	// Controls access to audio buffer
    bool m_bCleared;            // cleared buffers
    uint_t m_uiFrameMax;	// Max allowed frame_size
    uint_t m_uiFrameSize;	// Current amount of data
    uint_t m_uiFrameIn;
    uint_t m_uiFrameOut;	// Input and output positions in queue
    uint_t m_uiBytesPerSec;	// Input and output positions in queue
    uint8_t* m_pcAudioFrame;	// Audio queue
    double m_dRemains;          // Remainder for resampling
    IAudioResampler* m_pResampler;
    IAudioCleaner* m_pCleaner;
    WAVEFORMATEX m_Iwf;		// format of data we get from audio stream
    WAVEFORMATEX m_Owf;		// format of data we write to audio_fd
};

#endif // AVIFILE_AUDIOQUEUE_H
