#ifndef AVIFILE_AUDIOCLEANER_H
#define AVIFILE_AUDIOCLEANER_H

#include "default.h"
#include "formats.h"
#include <cstring>

class IAudioCleaner
{
protected:
    static const uint_t CLEARED_SAMPLES = 32;
    uint_t clearSize;
public:
    IAudioCleaner(uint_t clear) : clearSize(clear) {}
    virtual ~IAudioCleaner() {}
    virtual uint_t soundOff(void* out, const void* in) = 0;
    virtual uint_t soundOn(void* out, uint_t n) = 0;
};

template <class T> class AudioCleanerStereo : public IAudioCleaner
{
public:
    AudioCleanerStereo(uint_t clear) : IAudioCleaner(clear) {}
    uint_t soundOff(void* out, const void* in);
    uint_t soundOn(void* out, uint_t n);
};

template <class T> class AudioCleanerMono : public IAudioCleaner
{
public:
    AudioCleanerMono(uint_t clear) : IAudioCleaner(clear) {}
    uint_t soundOff(void* out, const void* in);
    uint_t soundOn(void* out, uint_t n);
};

IAudioCleaner* CreateAudioCleaner(uint_t channels,
				  uint_t bitsPerSample,
				  uint_t clearsz);

#endif // AVIFILE_AUDIOCLEANER_H
