#include "videodecoder.h"
#include "videoencoder.h"
#include "fourcc.h"

class Unc_Decoder: public IVideoDecoder
{
    CAPS m_Cap;
public:
    Unc_Decoder(const CodecInfo&, const BITMAPINFOHEADER&, int);
    virtual ~Unc_Decoder();
    virtual const BITMAPINFOHEADER& DestFmt() const { return m_obh; }
    CAPS GetCapabilities() const { return m_Cap; }
    virtual int DecodeInternal(const void* src, uint_t size, int is_keyframe, CImage* pImage);
    virtual void StartInternal();
    virtual void StopInternal();
    virtual int SetDestFmt(int bits, fourcc_t csp);
};

class Unc_Encoder: public IVideoEncoder
{
    BitmapInfo head;
    BitmapInfo chead;
public:
    Unc_Encoder(const CodecInfo& info, fourcc_t compressor, const BITMAPINFOHEADER& header);
    ~Unc_Encoder(){}
    virtual void Start(){}
    virtual void Stop(){}
    virtual void Restart(){}
    virtual int GetOutputSize() const;
    virtual const BITMAPINFOHEADER& GetOutputFormat() const;
    virtual int EncodeFrame(const CImage* src, void* dest, int* is_keyframe, uint_t* size, int* lpckid=0);
};

static void uncompressed_FillPlugins(avm::vector<CodecInfo>& ci)
{
    static const fourcc_t unc_rgb24[] = {0, 3, 0};
    static const fourcc_t unc_yuy2[] = {fccYUY2, 0};
    static const fourcc_t unc_yv12[] = {fccYV12, 0};

    ci.push_back(CodecInfo(unc_rgb24, "Uncompressed RGB", "",
			   "", CodecInfo::Source, "rgb"));
    ci.push_back(CodecInfo(unc_yuy2, "Uncompressed YUY2", "",
			   "", CodecInfo::Source, "yuy2"));
    ci.push_back(CodecInfo(unc_yv12, "Uncompressed YV12", "",
			   "", CodecInfo::Source, "yv12"));
}
