#ifndef AVIFILE_CREATORS_H
#define AVIFILE_CREATORS_H

#include "formats.h"
#include "infotypes.h"

class IAudioEncoder;
class IAudioDecoder;
class IVideoEncoder;
class IVideoDecoder;

#define CREATORS_BEGIN_NAMESPACE    namespace Creators {
#define CREATORS_END_NAMESPACE      };

CREATORS_BEGIN_NAMESPACE
/**
 *	Attempts to create decoder for specified format. Returns
 *	valid interface on success, 0 on failure.
 */

IAudioDecoder* CreateAudioDecoder(const WAVEFORMATEX* format, const char* privcname = 0);

/**
 * Creates the encoder for specified format. Pass desired format id in
 * fourcc ( see lib/libwin32/loader/wine/mmreg.h
 * (you could be more specific with the codec's name)
 * or lib/audiodecoder/audiodecoder.cpp
 * for values ) and format of input data in fmt.
 * Returns interface on success, 0 on failure.
 */
IAudioEncoder* CreateAudioEncoder(const CodecInfo& ci, const WAVEFORMATEX* fmt);
IAudioEncoder* CreateAudioEncoder(fourcc_t compressor, const WAVEFORMATEX* fmt);
IVideoDecoder* CreateVideoDecoder(const BITMAPINFOHEADER& bh, int depth = 24, int flip = 0, const char* privcname = 0);
IVideoEncoder* CreateVideoEncoder(const CodecInfo& ci, const BITMAPINFOHEADER& bh);
IVideoEncoder* CreateVideoEncoder(fourcc_t compressor, const BITMAPINFOHEADER& bh, const char* cname = 0);
IVideoEncoder* CreateVideoEncoder(const VideoEncoderInfo& info);
void FreeAudioDecoder(IAudioDecoder* decoder);
void FreeAudioEncoder(IAudioEncoder* encoder);
void FreeVideoDecoder(IVideoDecoder* decoder);
void FreeVideoEncoder(IVideoEncoder* encoder);

int GetCodecAttr(const CodecInfo& info, const char* attribute, int& value);
int SetCodecAttr(const CodecInfo& info, const char* attribute, int value);
int GetCodecAttr(const CodecInfo& info, const char* attribute, char* value, int size);
int SetCodecAttr(const CodecInfo& info, const char* attribute, const char* value);

/**
 * list of prefered codecs - delimited with commas  ","
 * e.g: DivX ;-) fast-motion,ATI VCR-1,
 *
 * spaces are important!
 * comma must not be in the codec's name!
 */
int SortVideoCodecs(const char* orderlist);
int SortAudioCodecs(const char* orderlist);

avm::string GetError();

CREATORS_END_NAMESPACE

#endif //AVIFILE_CREATORS_H
