#ifndef AVIFILE_CPUINFO_H
#define AVIFILE_CPUINFO_H

#include "default.h"

class CPU_Info
{
    double freq;
    bool have_tsc;
    bool have_mmx;
    bool have_mmxext;
    bool have_sse;
public:
    CPU_Info();
    /**
     * Returns nonzero if the processor supports MMX instruction set.
     */
    bool HaveMMX() const {return have_mmx;}
    /**
     * Returns nonzero if the processor supports extended integer MMX instruction set
     ( Pentium-III, AMD Athlon and compatibles )
     */
    bool HaveMMXEXT() const {return have_mmxext;}
    /**
     * Returns nonzero if the processor supports 'SSE' floating-point SIMD instruction set
     ( Pentium-III and compatibles )
     */
    bool HaveSSE() const {return have_sse;}
    /**
     * Returns nonzero if the processor has time-stamp counter feature.
     */
    bool HaveTSC() const {return have_tsc;}
    /**
     * Returns processor frequency in kHz.
     */
    operator double() const {return freq;}
};

extern CPU_Info freq;

/**
 *  Returns duration of time interval between two timestamps, received
 *  with longcount().
 */
inline float to_float(int64_t t2, int64_t t1)
{
    //  int64_t qw=t2-t1;
    //    qw=(int64_t)(qw/freq);//milliseconds;
    //    return ((int)qw)/1000.;
    return float((t2-t1)/freq/1000.);
}

#endif // AVIFILE_CPUINFO_H
