#ifndef AVIFILE_AUDIODECODER_H
#define AVIFILE_AUDIODECODER_H

/********************************************************
 *
 * Audio decoder abstract class.
 *
 * Performs decompression of data from
 * various audio formats into raw PCM
 *
 * Some methods are already implement to safe useless
 * source copying
 *
 ********************************************************/

#include "infotypes.h"

class IAudioDecoder
{
protected:
    WAVEFORMATEX in_fmt;
    const CodecInfo record;
public:
    IAudioDecoder(const CodecInfo& info, const WAVEFORMATEX* in);
    virtual ~IAudioDecoder() {}
    /**
     * Decodes data. It is guaranteed that either size_read or size_written
     * will receive nonzero value if out_size>=GetMinSize().
     */
    virtual int Convert(const void* in_data, uint_t in_size,
			void* out_data, uint_t out_size,
			uint_t* size_read, uint_t* size_written)	= 0;

    virtual const CodecInfo& GetCodecInfo() const;

    /**
     * Minimal required output buffer size. Calls to Convert() will
     * fail if you pass smaller output buffer to it.
     */
    virtual uint_t GetMinSize();
    /**
     * Returns output format for this audio decoder.
     */
    virtual int GetOutputFormat(WAVEFORMATEX* destfmt);
    /**
     * Estimates the amount ( in bytes ) of input data that's
     * required to produce specified amount of decompressed PCM data.
     */
    virtual uint_t GetSrcSize(uint_t dest_size);
};

#endif // AVIFILE_AUDIODECODER_H
