#ifndef AVIFILE_LOCKER_H
#define AVIFILE_LOCKER_H

// do not include pthread.h nor semaphore.h here
// hidden in the implementation

class PthreadMutex;
class PthreadCond;
class Locker;

class PthreadMutex
{
    void* m_pMutex; // pthread_mutex_t
friend class PthreadCond;
friend class Locker;
    PthreadMutex(const PthreadMutex&) :m_pMutex(0) {} //prohibited
    PthreadMutex& operator=(const PthreadMutex&) { return *this; } //prohibited
public:
    PthreadMutex();
    ~PthreadMutex();
    int Lock();
    int TryLock();
    int Unlock();
};

class PthreadCond
{
    void* m_pCond; // pthread_cond_t
    PthreadCond(const PthreadCond&) :m_pCond(0) {} //prohibited
    PthreadCond& operator=(const PthreadCond&) { return *this; } //prohibited
public:
    PthreadCond();
    ~PthreadCond();
    int Wait(PthreadMutex& m, float waitTime = -1.0);
    int Broadcast();
};

class PthreadSemaphore
{
    void* m_pSem; // sem_t
    PthreadSemaphore(const PthreadSemaphore&) :m_pSem(0) {} //prohibited
    PthreadSemaphore& operator=(const PthreadSemaphore&) { return *this; } //prohibited
public:
    PthreadSemaphore(int value);
    ~PthreadSemaphore();
    int Post();
    int Wait();
    int TryWait();
};

class PthreadTask
{
    void* m_pTask; // pthread_t
    PthreadTask(const PthreadTask&) :m_pTask(0) {} //prohibited
    PthreadTask& operator=(const PthreadTask&) { return *this; } //prohibited
public:
    PthreadTask(void* attr, void* (*start_routine)(void *), void* arg);
    ~PthreadTask();
};

class Locker
{
    void* m_pMutex;
    Locker(const Locker&) :m_pMutex(0) {} //prohibited
    Locker& operator=(const Locker&) { return *this; } //prohibited
public:
    Locker(PthreadMutex& mutex);
    //Locker(pthread_mutex_t* mutex);
    ~Locker();
};

#endif
