#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the VBD utility program
# C/C++ Compiler Used: Microsoft Visual C/C++ 4.2 
# Produced By: Doug Gaer
# File Creation Date: 04/14/1997 
# Date Last Modified: 03/17/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#       GX -- Enable C++ exception handling
#       GR -- Enable C++ Run-Time Type Information
# 	Zp -- Byte align structures (leave no gaps between members)
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = vb_debug

# Installation directory for the application and config files
INSTALL_DIR = ..\..\bin

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
VB_DEBUG_PATH = .
EHANDLER_PATH = ../../src
DTYPES_PATH = ../../src
REFCOUNT_PATH = ../../src
VBDFILE_PATH = ../../src
CRC32_PATH = ../../src

ADD_INC_PATHS = -I../../include

# Setup define macros
DEFMACS = /D__CONSOLE__

# Define macros for compiler and linker
CC = cl
CPP = cl
LINKER = link

# Define compiler and linker flags macros
CFLAGS= /Zi /W3 /GX $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = /c
LFLAGS =  

# Build dependency rules
# ===============================================================
VBDFILE_DEP = ../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/dtypes.h \
	../../include/int32.h \
	../../include/uint32.h 

EHANDLER_DEP = ../../include/ehandler.h 

CRC32_DEP = ../../include/crc32.h \
	../../include/crc32tab.h 

VBDFILE_DEP = ../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/dtypes.h \
	../../include/int32.h \
	../../include/uint32.h \
	../../include/crc32.h 

INT32_DEP =  ../../include/ehandler.h \
	../../include/dtypes.h \
	../../include/int32.h

UINT32_DEP =  ../../include/ehandler.h \
	../../include/dtypes.h \
	../../include/uint32.h

VB_DEBUG_DEP = ../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/dtypes.h \
	../../include/int32.h \
	../../include/vbdstats.h \
	../../include/uint32.h 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT).exe

vbdstats.obj:	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp

ehandler.obj:	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp

vbdfile.obj:	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp

vb_debug.obj:	$(VB_DEBUG_PATH)$(PATHSEP)vb_debug.cpp $(VB_DEBUG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VB_DEBUG_PATH)$(PATHSEP)vb_debug.cpp

int32.obj:	$(DTYPES_PATH)$(PATHSEP)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DTYPES_PATH)$(PATHSEP)int32.cpp

uint32.obj:	$(DTYPES_PATH)$(PATHSEP)uint32.cpp $(UINT31_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DTYPES_PATH)$(PATHSEP)uint32.cpp

crc32.obj:	$(CRC32_PATH)$(PATHSEP)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CRC32_PATH)$(PATHSEP)crc32.cpp

# Make the executable
OBJS = ehandler.obj vbdfile.obj vb_debug.obj int32.obj \
	uint32.obj crc32.obj vbdstats.obj
 
$(PROJECT).exe:	$(OBJS)
	$(LINKER) $(LFLAGS) $(OBJS) /OUT:$@ 
# ===============================================================

# ===============================================================
install:
	@echo Installing $(PROJECT) binaries to the bin directory...
	@if exist $(PROJECT).exe copy $(PROJECT).exe $(INSTALL_DIR)
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT).exe del $(PROJECT).exe 
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################


