# --------------------------------------------------------------- 
# Makefile Contents: Make file for the VBD utility program
# C/C++ Compiler Used: HP C++ A.10.24  compiled for HP-UX 10.20 
# Produced By: Doug Gaer      
# File Creation Date: 09/05/1997 
# Date Last Modified: 03/17/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v    -- Echo compilation
#       g    -- Enable debugging
#	+w   -- Turn on all warnings
#       +eh  -- Enable C++ exception handling
#	+a1  -- Allow ANSI C automatic aggregate initialization	
#	-pta -- Instantiate entire template class
#
#	+DAportable -- Generate code compatible across PA-RISC 1.1 
#	and 2.0 HP workstations and servers, use the option.  
#
#	+DSmodel --  Use the instruction scheduler tuned to the model
#	specified. model can be a model number, PA-RISC architecture 
#	designation or PA-RISC processor name. See the file:
#	/opt/langtools/lib/sched.models for a list of model numbers and 
#	processor names.  
#
#	+Oopt --  Invoke optimizations selected by opt. Defined values 
#	for opt are:
#
#	0    Perform minimal optimizations.  
#	1    Perform optimizations within basic blocks only.
#	2    Perform level 1 and global optimizations. Same as -O.
#	3    Perform level 2 as well as interprocedural global opts.
#	4    Perform level 3 as well as doing link time optimizations.
#	Also sends +Oprocelim and +Ofastaccess to the linker.
#
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define a name for the executable
PROJECT = vb_debug

# Installation directory for the application and config files
INSTALL_DIR = ../../bin

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
VB_DEBUG_PATH = .
EHANDLER_PATH = ../../src
DTYPES_PATH = ../../src
REFCOUNT_PATH = ../../src
VBDFILE_PATH = ../../src
CRC32_PATH = ../../src

ADD_INC_PATHS = -I../../include

# Setup define macros
DEFMACS = -D__CONSOLE__

# Define macros for compiler and linker
CC = cc
CPP = CC
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= +eh +a1 +DAportable $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS =  
# Build dependency rules
# ===============================================================
VBDFILE_DEP = ../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/dtypes.h \
	../../include/int32.h \
	../../include/uint32.h 

EHANDLER_DEP = ../../include/ehandler.h 

CRC32_DEP = ../../include/crc32.h \
	../../include/crc32tab.h 

VBDFILE_DEP = ../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/dtypes.h \
	../../include/int32.h \
	../../include/uint32.h \
	../../include/crc32.h 

INT32_DEP =  ../../include/ehandler.h \
	../../include/dtypes.h \
	../../include/int32.h

UINT32_DEP =  ../../include/ehandler.h \
	../../include/dtypes.h \
	../../include/uint32.h

VB_DEBUG_DEP = ../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/dtypes.h \
	../../include/int32.h \
	../../include/vbdstats.h \
	../../include/uint32.h 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

vbdstats.o:	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp

ehandler.o:	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp

vbdfile.o:	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp

vb_debug.o:	$(VB_DEBUG_PATH)$(PATHSEP)vb_debug.cpp $(VB_DEBUG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VB_DEBUG_PATH)$(PATHSEP)vb_debug.cpp

int32.o:	$(DTYPES_PATH)$(PATHSEP)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DTYPES_PATH)$(PATHSEP)int32.cpp

uint32.o:	$(DTYPES_PATH)$(PATHSEP)uint32.cpp $(UINT31_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DTYPES_PATH)$(PATHSEP)uint32.cpp

crc32.o:	$(CRC32_PATH)$(PATHSEP)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CRC32_PATH)$(PATHSEP)crc32.cpp

# Make the executable
OBJS = ehandler.o vbdfile.o vb_debug.o int32.o \
	uint32.o crc32.o vbdstats.o

$(PROJECT):	$(OBJS)
	$(CPP) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) 
# ===============================================================

# Install the binaries and config files to the bin directory
# ===============================================================
install:
	echo Installing $(PROJECT) binaries to the bin directory
	cp $(PROJECT) $(INSTALL_DIR)/. 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing template repository from working directory...
	rm -r -f ptrepository

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
