#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the VBD utility program
# C/C++ Compiler Used: DJGPP gcc 2.7.2.1 compiled for MSDOS 
# Produced By: Doug Gaer
# File Creation Date: 09/05/1997 
# Date Last Modified: 03/17/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v                   -- Echo compilation
#       g                   -- Enable debugging
#       Wall                -- Turn on warnings 
#       -fhandle-exceptions -- Enable C++ exception handling
#       -frtti              -- Enable C++ Run-Time Type Information
#
# Linker flags using gcc or ld
#	-lgpp    -- C++ Linkage
#	-lstdcx  -- Needed for Exception Handling and RTTI
#	-lm      -- Needed for Exception Handling
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = vb_debug

# Installation directory for the application and config files
INSTALL_DIR = ..\..\bin

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
VB_DEBUG_PATH = .
EHANDLER_PATH = ../../src
DTYPES_PATH = ../../src
REFCOUNT_PATH = ../../src
VBDFILE_PATH = ../../src
CRC32_PATH = ../../src

ADD_INC_PATHS = -I../../include

# Setup define macros
DEFMACS = -D__CONSOLE__

# Define macros for compiler and linker
CC = gcc
CPP = gcc
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -fhandle-exceptions $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
CPP_FLAG = -lgpp -lstdcx     
LFLAGS =  

# Build dependency rules
# ===============================================================
VBDFILE_DEP = ../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/dtypes.h \
	../../include/int32.h \
	../../include/uint32.h 

EHANDLER_DEP = ../../include/ehandler.h 

CRC32_DEP = ../../include/crc32.h \
	../../include/crc32tab.h 

VBDFILE_DEP = ../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/dtypes.h \
	../../include/int32.h \
	../../include/uint32.h \
	../../include/crc32.h 

INT32_DEP =  ../../include/ehandler.h \
	../../include/dtypes.h \
	../../include/int32.h

UINT32_DEP =  ../../include/ehandler.h \
	../../include/dtypes.h \
	../../include/uint32.h

VB_DEBUG_DEP = ../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/dtypes.h \
	../../include/int32.h \
	../../include/vbdstats.h \
	../../include/uint32.h 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

vbdstats.o:	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp

ehandler.o:	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp

vbdfile.o:	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp

vb_debug.o:	$(VB_DEBUG_PATH)$(PATHSEP)vb_debug.cpp $(VB_DEBUG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VB_DEBUG_PATH)$(PATHSEP)vb_debug.cpp

int32.o:	$(DTYPES_PATH)$(PATHSEP)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DTYPES_PATH)$(PATHSEP)int32.cpp

uint32.o:	$(DTYPES_PATH)$(PATHSEP)uint32.cpp $(UINT31_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DTYPES_PATH)$(PATHSEP)uint32.cpp

crc32.o:	$(CRC32_PATH)$(PATHSEP)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CRC32_PATH)$(PATHSEP)crc32.cpp

# Make the executable
OBJS = ehandler.o vbdfile.o vb_debug.o int32.o \
	uint32.o crc32.o vbdstats.o

$(PROJECT):	$(OBJS)
	$(CC) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) $(CPP_FLAG)
# ===============================================================

# ===============================================================
install:
	@echo Installing $(PROJECT) binaries to the bin directory...
	@if exist $(PROJECT).exe copy $(PROJECT).exe $(INSTALL_DIR)
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing COFF file from working directory...
	rm -f $(PROJECT)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT).exe
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
