#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the ASCII filter program
# C/C++ Compiler Used: GNU g++ 2.7.2.1 
# Produced By: Doug Gaer
# File Creation Date: 02/13/1996 
# Date Last Modified: 03/31/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v                   -- Echo compilation
#       g                   -- Enable debugging
#       Wall                -- Turn on warnings 
#       -fhandle-exceptions -- Enable C++ exception handling
#       -frtti              -- Enable C++ Run-Time Type Information
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define a name for the executable
PROJECT = txfilter

# Installation directory for the application and config files
INSTALL_DIR = ../../bin

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
TXFILTER_PATH =.
ADD_INC_PATHS = 

# Setup define macros
DEFMACS = -D__UNIX__

# Define macros for compiler and linker
CC = gcc
CPP = g++
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -fhandle-exceptions $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS =  

# Build dependency rules
# ===============================================================
TXFILTER_DEP = 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

txfilter.o:	$(TXFILTER_PATH)$(PATHSEP)txfilter.cpp $(TXFILTER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(TXFILTER_PATH)$(PATHSEP)txfilter.cpp

# Make the executable
OBJS = txfilter.o 

$(PROJECT):	$(OBJS)
	$(CPP) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) 
# ===============================================================

# Install the binaries and config files to the bin directory
# ===============================================================
install:
	echo Installing $(PROJECT) binaries to the bin directory
	cp $(PROJECT) $(INSTALL_DIR)/. 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
