#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the VBD utility program
# C/C++ Compiler Used: Microsoft Visual C/C++ 4.2 
# Produced By: Doug Gaer
# File Creation Date: 04/14/1997 
# Date Last Modified: 03/17/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#       GX -- Enable C++ exception handling
#       GR -- Enable C++ Run-Time Type Information
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = ix_debug

# Installation directory for the application and config files
INSTALL_DIR = ..\..\bin

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
IX_DEBUG_PATH = .
BTREE_PATH = ../../src
CACHE_PATH = ../../src
PLACENEW_PATH = ../../src
EHANDLER_PATH = ../../src
DTYPES_PATH = ../../src
REFCOUNT_PATH = ../../src
VBDFILE_PATH = ../../src
QUEUE_PATH = ../../src
SLLISTB_PATH = ../../src
STACK_PATH = ../../src
USTRING_PATH = ../../src
STRUTIL_PATH = ../../src
CRC32_PATH = ../../src
DLLISTB_PATH = ../../src

ADD_INC_PATHS = -I../../include

# Use this DEFMACS macro to compile without using template classes
DEFMACS = /D__NOT_USING_TEMPLATE_CLASS__ /D__BTREE_MNODE__ /D__CONSOLE__ \
/D__USE_VBDREFCOUNT__ /D__DOS__

# Enable to use the template classes
# DEFMACS = /D__CONSOLE__ /D__DOS__

# Define macros for compiler and linker
CC = cl
CPP = cl
LINKER = link

# Define compiler and linker flags macros
CFLAGS= /Zi /GX $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = /c
LFLAGS =  

# Build dependency rules
# ===============================================================
VBDFILE_DEP = ../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/dtypes.h \
	../../include/int32.h \
	../../include/uint32.h 

CRC32_DEP = ../../include/crc32.h \
	../../include/crc32tab.h 

UINT32_DEP =  ../../include/ehandler.h \
	../../include/dtypes.h \
	../../include/uint32.h

BUCKET_DEP = ../../include/bucket.h \
	../../include/cacheb.h \
	../../include/cactype.h \
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/mnode.h \
	../../include/refcount.h \
	../../include/uint32.h 

CACHE_DEP = ../../include/bucketb.h \
	../../include/cacheb.h \
	../../include/cactype.h \
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/mnode.h \
	../../include/refcount.h \
	../../include/uint32.h 

CACHEB_DEP = ../../include/bucketb.h \
	../../include/cacheb.h \
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/int32.h \
	../../include/dtypes.h \
	../../include/uint32.h 

CACSTATS_DEP = ../../include/bucketb.h \
	../../include/cacheb.h \
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/int32.h \
	../../include/dtypes.h \
	../../include/cacstats.h \
	../../include/uint32.h 

CHPTRB_DEP = ../../include/bucket.h \
	../../include/bucketb.h \
	../../include/cache.h \
	../../include/cacheb.h \
	../../include/chptrb.h \
	../../include/cactype.h\
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/int32.h \
	../../include/dtypes.h \
	../../include/uint32.h 

MNODE_DEP = ../../include/mnode.h \
	../../include/ehandler.h \
	../../include/int32.h \
	../../include/dtypes.h \
	../../include/entrykey.h

ENTRYKEY_DEP = ../../include/entrykey.h \
	../../include/ehandler.h \
	../../include/int32.h \
	../../include/dtypes.h \
	../../include/strutil.h 

BTREE_DEP = ../../include/bucket.h \
	../../include/bucketb.h \
	../../include/cache.h \
	../../include/cacheb.h \
	../../include/chptrb.h \
	../../include/cactype.h\
	../../include/cacheptr.h \
	../../include/btree.h \
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/placenew.h \
	../../include/mnode.h \
	../../include/int32.h\
	../../include/dtypes.h \
	../../include/entrykey.h \
	../../include/uint32.h 

BTREEPRT_DEP = ../../include/bucket.h \
	../../include/bucketb.h \
	../../include/cache.h \
	../../include/cacheb.h \
	../../include/chptrb.h \
	../../include/cactype.h\
	../../include/cacheptr.h \
	../../include/btree.h \
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/placenew.h \
	../../include/mnode.h \
	../../include/int32.h\
	../../include/dtypes.h \
	../../include/entrykey.h \
	../../include/btreeprt.h \
	../../include/uint32.h 

BTWALK_DEP = ../../include/bucket.h \
	../../include/bucketb.h \
	../../include/cache.h \
	../../include/cacheb.h \
	../../include/chptrb.h \
	../../include/cactype.h\
	../../include/cacheptr.h \
	../../include/btree.h \
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/placenew.h \
	../../include/mnode.h \
	../../include/int32.h\
	../../include/dtypes.h \
	../../include/entrykey.h \
	../../include/btwalk.h \
	../../include/ustring.h \
	../../include/strutil.h \
	../../include/uint32.h 	

EHANDLER_DEP = ../../include/ehandler.h

INT32_DEP = ../../include/dtypes.h \
	../../include/ehandler.h \
	../../include/int32.h

VBDFILE_DEP = ../../include/dtypes.h \
	../../include/ehandler.h \
	../../include/int32.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/uint32.h \
	../../include/crc32.h 

VBDREF_DEP = ../../include/vbdfile.h \
	../../include/vbdref.h \
	../../include/refcount.h

SLLISTB_DEP = ../../include/sllistb.h

USTRING_DEP = ../../include/ustring.h

IX_DEBUG_DEP = ../../include/bucket.h \
	../../include/bucketb.h \
	../../include/cache.h \
	../../include/cacheb.h \
	../../include/chptrb.h \
	../../include/cacheptr.h \
	../../include/cactype.h \
	../../include/btree.h \
	../../include/ehandler.h \
	../../include/int32.h \
        ../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/placenew.h \
	../../include/mnode.h \
	../../include/entrykey.h \
	../../include/btreeprt.h \
	../../include/cacstats.h \
	../../include/queue.h \
	../../include/sllist.h \
	../../include/sllistb.h \
	../../include/stack.h \
	../../include/ustring.h \
	../../include/strutil.h \
	../../include/btwalk.h \
	../../include/vbdstats.h \
	../../include/btwalker.h  \
	../../include/uint32.h \
	../../include/dllistb.h 

BTWALKER_DEP = ../../include/bucket.h \
	../../include/bucketb.h \
	../../include/cache.h \
	../../include/cacheb.h \
	../../include/chptrb.h \
	../../include/cactype.h\
	../../include/cacheptr.h \
	../../include/btree.h \
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/placenew.h \
	../../include/int32.h  \
	../../include/dtypes.h \
	../../include/mnode.h \
	../../include/btreeprt.h \
	../../include/entrykey.h \
	../../include/sllistb.h \
	../../include/dllistb.h \
	../../include/dllist.h \
	../../include/stack.h \
	../../include/queue.h \
	../../include/strutil.h 

DLLISTB_DEP = ../../include/dllistb.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT).exe

btwalker.obj:	$(BTREE_PATH)$(PATHSEP)btwalker.cpp $(BTWALKER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)btwalker.cpp

dllistb.obj:	$(DLLISTB_PATH)$(PATHSEP)dllistb.cpp $(DLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DLLISTB_PATH)$(PATHSEP)dllistb.cpp

vbdstats.obj:	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp

uint32.obj:	$(DTYPES_PATH)$(PATHSEP)uint32.cpp $(UINT31_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DTYPES_PATH)$(PATHSEP)uint32.cpp

crc32.obj:	$(CRC32_PATH)$(PATHSEP)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CRC32_PATH)$(PATHSEP)crc32.cpp

bucket.obj:	$(CACHE_PATH)$(PATHSEP)bucket.cpp $(BUCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)bucket.cpp

cache.obj:	$(CACHE_PATH)$(PATHSEP)cache.cpp $(CACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)cache.cpp

cacheb.obj:	$(CACHE_PATH)$(PATHSEP)cacheb.cpp $(CACHEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)cacheb.cpp

chptrb.obj:	$(CACHE_PATH)$(PATHSEP)chptrb.cpp $(CHPTRB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)chptrb.cpp

cacstats.obj:	$(CACHE_PATH)$(PATHSEP)cacstats.cpp $(CACSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)cacstats.cpp

mnode.obj:	$(BTREE_PATH)$(PATHSEP)mnode.cpp $(MNODE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)mnode.cpp

entrykey.obj:	$(BTREE_PATH)$(PATHSEP)entrykey.cpp $(ENTRYKEY_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)entrykey.cpp

btreeprt.obj:	$(BTREE_PATH)$(PATHSEP)btreeprt.cpp $(BTREEPRT_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)btreeprt.cpp

btwalk.obj:	$(BTREE_PATH)$(PATHSEP)btwalk.cpp $(BTWALK_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)btwalk.cpp

btree.obj:	$(BTREE_PATH)$(PATHSEP)btree.cpp $(BTREE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)btree.cpp

ehandler.obj:	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp

int32.obj:	$(DTYPES_PATH)$(PATHSEP)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DTYPES_PATH)$(PATHSEP)int32.cpp

vbdfile.obj:    $(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp

vbdref.obj:	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp $(VBDREF_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp

sllistb.obj:	$(SLLISTB_PATH)$(PATHSEP)sllistb.cpp $(SLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.cpp

ix_debug.obj:	$(IX_DEBUG_PATH)$(PATHSEP)ix_debug.cpp $(IX_DEBUG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(IX_DEBUG_PATH)$(PATHSEP)ix_debug.cpp

ustring.obj:	$(USTRING_PATH)$(PATHSEP)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(USTRING_PATH)$(PATHSEP)ustring.cpp

strutil.obj:	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp $(STRUTIL_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp

# Make the executable
OBJS = cacheb.obj chptrb.obj btree.obj ehandler.obj vbdfile.obj \
	ix_debug.obj mnode.obj int32.obj bucket.obj cache.obj \
	vbdref.obj entrykey.obj btreeprt.obj cacstats.obj \
	sllistb.obj btwalker.obj ustring.obj btwalk.obj strutil.obj \
	uint32.obj crc32.obj vbdstats.obj dllistb.obj
 
$(PROJECT).exe:	$(OBJS)
	$(LINKER) $(LFLAGS) $(OBJS) /OUT:$@ 
# ===============================================================

# ===============================================================
install:
	@echo Installing $(PROJECT) binaries to the bin directory...
	@if exist $(PROJECT).exe copy $(PROJECT).exe $(INSTALL_DIR)
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT).exe del $(PROJECT).exe 
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################


