#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the VBD utility program
# C/C++ Compiler Used: HP C++ A.10.24  compiled for HP-UX 10.20 
# Produced By: Doug Gaer      ^^^^^^^
# File Creation Date: 04/14/1997 
# Date Last Modified: 03/17/1999
#
# NOTE: If using the template classes this program will not 
# compile under HP C++ A.10.09. The template version of the 
# Bucket class uses a template parameter as base class, which 
# was not allowed in this version of HP C++. To get the current 
# version number enter the following command:
# 
# % what /opt/CC/bin/CC
# ***************************************************************
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	v    -- Echo compilation
#	g    -- Enable debugging
#	+w   -- Turn on all warnings
#	+a1  -- Allow ANSI C automatic aggregate initialization	
#	-pta -- Instantiate entire template class
#       +eh -- Enable C++ exception handling
#
#	+DAportable -- Generate code compatible across PA-RISC 1.1 
#	and 2.0 HP workstations and servers, use the option.  
#
#	+DSmodel --  Use the instruction scheduler tuned to the model
#	specified. model can be a model number, PA-RISC architecture 
#	designation or PA-RISC processor name. See the file:
#	/opt/langtools/lib/sched.models for a list of model numbers and 
#	processor names.  
#
#	+Oopt --  Invoke optimizations selected by opt. Defined values 
#	for opt are:
#
#	0    Perform minimal optimizations.  
#	1    Perform optimizations within basic blocks only.
#	2    Perform level 1 and global optimizations. Same as -O.
#	3    Perform level 2 as well as interprocedural global opts.
#	4    Perform level 3 as well as doing link time optimizations.
#	Also sends +Oprocelim and +Ofastaccess to the linker.
#
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define a name for the executable
PROJECT = ix_debug

# Installation directory for the application and config files
INSTALL_DIR = ../../bin

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
IX_DEBUG_PATH = .
BTREE_PATH = ../../src
CACHE_PATH = ../../src
PLACENEW_PATH = ../../src
EHANDLER_PATH = ../../src
DTYPES_PATH = ../../src
REFCOUNT_PATH = ../../src
VBDFILE_PATH = ../../src
QUEUE_PATH = ../../src
SLLISTB_PATH = ../../src
STACK_PATH = ../../src
USTRING_PATH = ../../src
STRUTIL_PATH = ../../src
CRC32_PATH = ../../src
DLLISTB_PATH = ../../src

ADD_INC_PATHS = -I../../include

# Use this DEFMACS macro to compile without using template classes
DEFMACS = -D__NOT_USING_TEMPLATE_CLASS__ -D__BTREE_MNODE__ -D__CONSOLE__ \
-D__USE_VBDREFCOUNT__ -D__UNIX__

# Enable to use the template classes
# DEFMACS = -D__CONSOLE__ -D__UNIX__

# Define macros for compiler and linker
CC = cc
CPP = CC
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= +a1 -pta +DAportable +eh $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS =  

# Build dependency rules
# ===============================================================
VBDFILE_DEP = ../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/dtypes.h \
	../../include/int32.h \
	../../include/uint32.h 

CRC32_DEP = ../../include/crc32.h \
	../../include/crc32tab.h 

UINT32_DEP =  ../../include/ehandler.h \
	../../include/dtypes.h \
	../../include/uint32.h

BUCKET_DEP = ../../include/bucket.h \
	../../include/cacheb.h \
	../../include/cactype.h \
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/mnode.h \
	../../include/refcount.h \
	../../include/uint32.h 

CACHE_DEP = ../../include/bucketb.h \
	../../include/cacheb.h \
	../../include/cactype.h \
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/mnode.h \
	../../include/refcount.h \
	../../include/uint32.h 

CACHEB_DEP = ../../include/bucketb.h \
	../../include/cacheb.h \
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/int32.h \
	../../include/dtypes.h \
	../../include/uint32.h 

CACSTATS_DEP = ../../include/bucketb.h \
	../../include/cacheb.h \
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/int32.h \
	../../include/dtypes.h \
	../../include/cacstats.h \
	../../include/uint32.h 

CHPTRB_DEP = ../../include/bucket.h \
	../../include/bucketb.h \
	../../include/cache.h \
	../../include/cacheb.h \
	../../include/chptrb.h \
	../../include/cactype.h\
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/int32.h \
	../../include/dtypes.h \
	../../include/uint32.h 

MNODE_DEP = ../../include/mnode.h \
	../../include/ehandler.h \
	../../include/int32.h \
	../../include/dtypes.h \
	../../include/entrykey.h

ENTRYKEY_DEP = ../../include/entrykey.h \
	../../include/ehandler.h \
	../../include/int32.h \
	../../include/dtypes.h \
	../../include/strutil.h 

BTREE_DEP = ../../include/bucket.h \
	../../include/bucketb.h \
	../../include/cache.h \
	../../include/cacheb.h \
	../../include/chptrb.h \
	../../include/cactype.h\
	../../include/cacheptr.h \
	../../include/btree.h \
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/placenew.h \
	../../include/mnode.h \
	../../include/int32.h\
	../../include/dtypes.h \
	../../include/entrykey.h \
	../../include/uint32.h 

BTREEPRT_DEP = ../../include/bucket.h \
	../../include/bucketb.h \
	../../include/cache.h \
	../../include/cacheb.h \
	../../include/chptrb.h \
	../../include/cactype.h\
	../../include/cacheptr.h \
	../../include/btree.h \
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/placenew.h \
	../../include/mnode.h \
	../../include/int32.h\
	../../include/dtypes.h \
	../../include/entrykey.h \
	../../include/btreeprt.h \
	../../include/uint32.h 

BTWALK_DEP = ../../include/bucket.h \
	../../include/bucketb.h \
	../../include/cache.h \
	../../include/cacheb.h \
	../../include/chptrb.h \
	../../include/cactype.h\
	../../include/cacheptr.h \
	../../include/btree.h \
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/placenew.h \
	../../include/mnode.h \
	../../include/int32.h\
	../../include/dtypes.h \
	../../include/entrykey.h \
	../../include/btwalk.h \
	../../include/ustring.h \
	../../include/strutil.h \
	../../include/uint32.h 	

EHANDLER_DEP = ../../include/ehandler.h

INT32_DEP = ../../include/dtypes.h \
	../../include/ehandler.h \
	../../include/int32.h

VBDFILE_DEP = ../../include/dtypes.h \
	../../include/ehandler.h \
	../../include/int32.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/uint32.h \
	../../include/crc32.h 

VBDREF_DEP = ../../include/vbdfile.h \
	../../include/vbdref.h \
	../../include/refcount.h

SLLISTB_DEP = ../../include/sllistb.h

USTRING_DEP = ../../include/ustring.h

IX_DEBUG_DEP = ../../include/bucket.h \
	../../include/bucketb.h \
	../../include/cache.h \
	../../include/cacheb.h \
	../../include/chptrb.h \
	../../include/cacheptr.h \
	../../include/cactype.h \
	../../include/btree.h \
	../../include/ehandler.h \
	../../include/int32.h \
        ../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/placenew.h \
	../../include/mnode.h \
	../../include/entrykey.h \
	../../include/btreeprt.h \
	../../include/cacstats.h \
	../../include/queue.h \
	../../include/sllist.h \
	../../include/sllistb.h \
	../../include/stack.h \
	../../include/ustring.h \
	../../include/strutil.h \
	../../include/btwalk.h \
	../../include/vbdstats.h \
	../../include/btwalker.h  \
	../../include/uint32.h \
	../../include/dllistb.h 

BTWALKER_DEP = ../../include/bucket.h \
	../../include/bucketb.h \
	../../include/cache.h \
	../../include/cacheb.h \
	../../include/chptrb.h \
	../../include/cactype.h\
	../../include/cacheptr.h \
	../../include/btree.h \
	../../include/ehandler.h \
	../../include/vbdfile.h \
	../../include/refcount.h \
	../../include/placenew.h \
	../../include/int32.h  \
	../../include/dtypes.h \
	../../include/mnode.h \
	../../include/btreeprt.h \
	../../include/entrykey.h \
	../../include/sllistb.h \
	../../include/dllistb.h \
	../../include/dllist.h \
	../../include/stack.h \
	../../include/queue.h \
	../../include/strutil.h 

DLLISTB_DEP = ../../include/dllistb.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

btwalker.o:	$(BTREE_PATH)$(PATHSEP)btwalker.cpp $(BTWALKER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)btwalker.cpp

dllistb.o:	$(DLLISTB_PATH)$(PATHSEP)dllistb.cpp $(DLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DLLISTB_PATH)$(PATHSEP)dllistb.cpp

vbdstats.o:	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp

uint32.o:	$(DTYPES_PATH)$(PATHSEP)uint32.cpp $(UINT31_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DTYPES_PATH)$(PATHSEP)uint32.cpp

crc32.o:	$(CRC32_PATH)$(PATHSEP)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CRC32_PATH)$(PATHSEP)crc32.cpp

bucket.o:	$(CACHE_PATH)$(PATHSEP)bucket.cpp $(BUCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)bucket.cpp

cache.o:	$(CACHE_PATH)$(PATHSEP)cache.cpp $(CACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)cache.cpp

cacheb.o:	$(CACHE_PATH)$(PATHSEP)cacheb.cpp $(CACHEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)cacheb.cpp

chptrb.o:	$(CACHE_PATH)$(PATHSEP)chptrb.cpp $(CHPTRB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)chptrb.cpp

cacstats.o:	$(CACHE_PATH)$(PATHSEP)cacstats.cpp $(CACSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)cacstats.cpp

mnode.o:	$(BTREE_PATH)$(PATHSEP)mnode.cpp $(MNODE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)mnode.cpp

entrykey.o:	$(BTREE_PATH)$(PATHSEP)entrykey.cpp $(ENTRYKEY_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)entrykey.cpp

btreeprt.o:	$(BTREE_PATH)$(PATHSEP)btreeprt.cpp $(BTREEPRT_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)btreeprt.cpp

btwalk.o:	$(BTREE_PATH)$(PATHSEP)btwalk.cpp $(BTWALK_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)btwalk.cpp

btree.o:	$(BTREE_PATH)$(PATHSEP)btree.cpp $(BTREE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)btree.cpp

ehandler.o:	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp

int32.o:	$(DTYPES_PATH)$(PATHSEP)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DTYPES_PATH)$(PATHSEP)int32.cpp

vbdfile.o:    $(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp

vbdref.o:	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp $(VBDREF_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp

sllistb.o:	$(SLLISTB_PATH)$(PATHSEP)sllistb.cpp $(SLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.cpp

ix_debug.o:	$(IX_DEBUG_PATH)$(PATHSEP)ix_debug.cpp $(IX_DEBUG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(IX_DEBUG_PATH)$(PATHSEP)ix_debug.cpp

ustring.o:	$(USTRING_PATH)$(PATHSEP)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(USTRING_PATH)$(PATHSEP)ustring.cpp

strutil.o:	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp $(STRUTIL_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp

# Make the executable
OBJS = cacheb.o chptrb.o btree.o ehandler.o vbdfile.o \
	ix_debug.o mnode.o int32.o bucket.o cache.o \
	vbdref.o entrykey.o btreeprt.o cacstats.o \
	sllistb.o btwalker.o ustring.o btwalk.o strutil.o \
	uint32.o crc32.o vbdstats.o dllistb.o

$(PROJECT):	$(OBJS)
	$(CPP) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) 
# ===============================================================

# Install the binaries and config files to the bin directory
# ===============================================================
install:
	echo Installing $(PROJECT) binaries to the bin directory
	cp $(PROJECT) $(INSTALL_DIR)/. 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)

	echo Removing template repository from working directory...
	rm -r -f ptrepository
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
