#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the hexdump program
# C/C++ Compiler Used: DJGPP gcc 2.7.2.1 compiled for MSDOS 
# Produced By: Doug Gaer
# File Creation Date: 02/13/1996 
# Date Last Modified: 03/17/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v                   -- Echo compilation
#       g                   -- Enable debugging
#       Wall                -- Turn on warnings 
#       -fhandle-exceptions -- Enable C++ exception handling
#       -frtti              -- Enable C++ Run-Time Type Information
#
# Linker flags using gcc or ld
#	-lgpp    -- C++ Linkage
#	-lstdcx  -- Needed for Exception Handling and RTTI
#	-lm      -- Needed for Exception Handling
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = hexdump

# Installation directory for the application and config files
INSTALL_DIR = ..\..\bin

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
HEXDUMP_PATH =.
HXCRC_PATH =.

ADD_INC_PATHS = 

# Setup define macros
DEFMACS = -D__DJGPP2721__

# Define macros for compiler and linker
CC = gcc
CPP = gcc
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -fhandle-exceptions $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
CPP_FLAG = -lgpp -lstdcx     
LFLAGS =  

# Build dependency rules
# ===============================================================
HEXDUMP_DEP = $(HXCRC_PATH)$(PATHSEP)hxcrc.h

HXCRC_DEP = $(HXCRC_PATH)$(PATHSEP)hxcrc.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

hexdump.o:	$(HEXDUMP_PATH)$(PATHSEP)hexdump.cpp $(HEXDUMP_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(HEXDUMP_PATH)$(PATHSEP)hexdump.cpp

hxcrc.o:	$(HXCRC_PATH)$(PATHSEP)hxcrc.cpp $(HXCRC_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(HXCRC_PATH)$(PATHSEP)hxcrc.cpp

# Make the executable
OBJS = hexdump.o hxcrc.o

$(PROJECT):	$(OBJS)
	$(CC) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) $(CPP_FLAG)
# ===============================================================

# ===============================================================
install:
	@echo Installing $(PROJECT) binaries to the bin directory...
	@if exist $(PROJECT).exe copy $(PROJECT).exe $(INSTALL_DIR)
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing COFF file from working directory...
	rm -f $(PROJECT)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT).exe
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
