#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program
# C/C++ Compiler Used: HP C++ A.10.24  compiled for HP-UX 10.20 
# Produced By: Doug Gaer
# File Creation Date: 03/09/1999 
# Date Last Modified: 03/26/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	v   -- Echo compilation
#	g   -- Enable debugging
#	+w  -- Turn on all warnings
#       +eh  -- Enable C++ exception handling
#	+a1 -- Allow ANSI C automatic aggregate initialization	
#	-pta -- Instantiate entire template class
#
#	+DAportable -- Generate code compatible across PA-RISC 1.1 
#	and 2.0 HP workstations and servers, use the option.  
#
#	+DSmodel --  Use the instruction scheduler tuned to the model
#	specified. model can be a model number, PA-RISC architecture 
#	designation or PA-RISC processor name. See the file:
#	/opt/langtools/lib/sched.models for a list of model numbers and 
#	processor names.  
#
#	+Oopt --  Invoke optimizations selected by opt. Defined values 
#	for opt are:
#
#	0    Perform minimal optimizations.  
#	1    Perform optimizations within basic blocks only.
#	2    Perform level 1 and global optimizations. Same as -O.
#	3    Perform level 2 as well as interprocedural global opts.
#	4    Perform level 3 as well as doing link time optimizations.
#	Also sends +Oprocelim and +Ofastaccess to the linker.
#
# Linker flags 
#	-lm -- Needed for math library
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define a name for the executable
PROJECT = ffind

# Installation directory for the application and config files
INSTALL_DIR = ../../bin

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
FFIND_PATH = .
USTRING_PATH = ../../src
STRUTIL_PATH = ../../src
DLLIST_PATH = ../../src

ADD_INC_PATHS = -I../../include

# Setup define macros
DEFMACS = -D__UNIX__

# Define macros for compiler and linker
CC = cc
CPP = CC
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -v +a1 +DAportable -pta $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS =  

# Build dependency rules
# ===============================================================
USTRING_DEP = ../../include/ustring.h

STRUTIL_DEP = ../../include/strutil.h

FFIND_DEP = ../../include/ustring.h \
	../../include/strutil.h

DLLISTB_DEP = ../../include/dllistb.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

ustring.o:	$(USTRING_PATH)$(PATHSEP)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(USTRING_PATH)$(PATHSEP)ustring.cpp

strutil.o:	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp $(STRUTIL_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp

ffind.o:	$(FFIND_PATH)$(PATHSEP)ffind.cpp $(FFIND_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(FFIND_PATH)$(PATHSEP)ffind.cpp

dllistb.o:	$(DLLIST_PATH)$(PATHSEP)dllistb.cpp $(DLLIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DLLIST_PATH)$(PATHSEP)dllistb.cpp

# Make the executable
OBJECTS = ustring.o strutil.o ffind.o dllistb.o

$(PROJECT):	$(OBJECTS)
	$(CPP) $(CFLAGS) $(OBJECTS) $(OUTPUT) $(PROJECT) 
# ===============================================================

# Install the binaries and config files to the bin directory
# ===============================================================
install:
	echo Installing $(PROJECT) binaries to the bin directory
	cp $(PROJECT) $(INSTALL_DIR)/. 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing template repository from working directory...
	rm -r -f ptrepository

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
