#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program 
# C/C++ Compiler Used: DJGPP gcc 2.7.2.1 compiled for MSDOS 
# Produced By: Doug Gaer
# File Creation Date: 03/09/1999 
# Date Last Modified: 03/26/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v -- Echo compilation
#       g -- Enable debugging
#       Wall -- Turn on warnings 
#
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = ffind

# Installation directory for the application and config files
INSTALL_DIR = ..\..\bin

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
FFIND_PATH = .
USTRING_PATH = ../../src
STRUTIL_PATH = ../../src
DLLIST_PATH = ../../src

ADD_INC_PATHS = -I../../include

# Setup define macros
DEFMACS = -D__DOS__ 

# Define macros for compiler and linker
CC = gcc
CPP = gcc 
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -Wall $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
CPP_FLAG = -lgpp     
LFLAGS =  

# Build dependency rules
# ===============================================================
USTRING_DEP = ../../include/ustring.h

STRUTIL_DEP = ../../include/strutil.h

FFIND_DEP = ../../include/ustring.h \
	../../include/strutil.h

DLLISTB_DEP = ../../include/dllistb.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

ustring.o:	$(USTRING_PATH)$(PATHSEP)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(USTRING_PATH)$(PATHSEP)ustring.cpp

strutil.o:	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp $(STRUTIL_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp

ffind.o:	$(FFIND_PATH)$(PATHSEP)ffind.cpp $(FFIND_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(FFIND_PATH)$(PATHSEP)ffind.cpp

dllistb.o:	$(DLLIST_PATH)$(PATHSEP)dllistb.cpp $(DLLIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DLLIST_PATH)$(PATHSEP)dllistb.cpp

# Make the executable
OBJECTS = ustring.o strutil.o ffind.o dllistb.o

$(PROJECT):	$(OBJECTS)
	$(CC) $(CFLAGS) $(OBJECTS) $(OUTPUT) $(PROJECT) $(CPP_FLAG)
# ===============================================================

# ===============================================================
install:
	@echo Installing $(PROJECT) binaries to the bin directory...
	@if exist $(PROJECT).exe copy $(PROJECT).exe $(INSTALL_DIR)
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing COFF file from working directory...
	rm -f $(PROJECT)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT).exe
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
