#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the ASCII to PostScript converter program.
# C/C++ Compiler Used: Microsoft Visual C/C++ 4.2 
# Produced By: Doug Gaer
# File Creation Date: 12/17/1997  
# Date Last Modified: 03/31/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#       GX -- Enable C++ exception handling
#       GR -- Enable C++ Run-Time Type Information
# 	Zp -- Byte align structures (leave no gaps between members)
#
# NOTE: None of the MSVC compilers will expand wildcard characters
# used in command-line arguments unless linked with the setargv.obj
# library. All the UNIX compliers will expand wildcard characters
# by default.
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = as2ps

# Installation directory for the application and config files
INSTALL_DIR = ..\..\bin

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
AS2PS_PATH = .
PSCRIPT_PATH = ../../src

ADD_INC_PATHS = -I../../include

# Setup define macros
DEFMACS = 

# Define macros for compiler and linker
CC = cl
CPP = cl
LINKER = link

# Define compiler and linker flags macros
CFLAGS= /Zi /W3 /GX $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = /c
LFLAGS =  

# Additional libraries
LIBRARIES = setargv.obj # Expands wildcard characters

# Build dependency rules
# ===============================================================
PSCRIPT_DEP = ../../include/pscript.h 

AS2PS_DEP = ../../include/pscript.h \
	$(AS2PS_PATH)$(PATHSEP)as2ps.h 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT).exe

pscript.obj:	$(PSCRIPT_PATH)$(PATHSEP)pscript.cpp $(PSCRIPT_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(PSCRIPT_PATH)$(PATHSEP)pscript.cpp

as2ps.obj:	$(AS2PS_PATH)$(PATHSEP)as2ps.cpp $(AS2PS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(AS2PS_PATH)$(PATHSEP)as2ps.cpp

# Make the executable
OBJS = pscript.obj as2ps.obj 
 
$(PROJECT).exe:	$(OBJS)
	$(LINKER) $(LFLAGS) $(OBJS) $(LIBRARIES) /OUT:$@ 
# ===============================================================

# ===============================================================
install:
	@echo Installing $(PROJECT) binaries to the bin directory...
	@if exist $(PROJECT).exe copy $(PROJECT).exe $(INSTALL_DIR)
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT).exe del $(PROJECT).exe 
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################


