#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the ASCII to PostScript converter program.
# C/C++ Compiler Used: DJGPP gcc 2.7.2.1 compiled for MSDOS 
# Produced By: Doug Gaer
# File Creation Date: 12/17/1997  
# Date Last Modified: 03/31/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v                   -- Echo compilation
#       g                   -- Enable debugging
#       Wall                -- Turn on warnings 
#       -fhandle-exceptions -- Enable C++ exception handling
#       -frtti              -- Enable C++ Run-Time Type Information
#
# Linker flags using gcc or ld
#	-lgpp    -- C++ Linkage
#	-lstdcx  -- Needed for Exception Handling and RTTI
#	-lm      -- Needed for Exception Handling
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = as2ps

# Installation directory for the application and config files
INSTALL_DIR = ..\..\bin

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
AS2PS_PATH = .
PSCRIPT_PATH = ../../src

ADD_INC_PATHS = -I../../include

# Setup define macros
DEFMACS = 

# Define macros for compiler and linker
CC = gcc
CPP = gcc
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -fhandle-exceptions $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
CPP_FLAG = -lgpp -lstdcx     
LFLAGS =  

# Build dependency rules
# ===============================================================
PSCRIPT_DEP = ../../include/pscript.h 

AS2PS_DEP = ../../include/pscript.h \
	$(AS2PS_PATH)$(PATHSEP)as2ps.h 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

pscript.o:	$(PSCRIPT_PATH)$(PATHSEP)pscript.cpp $(PSCRIPT_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(PSCRIPT_PATH)$(PATHSEP)pscript.cpp

as2ps.o:	$(AS2PS_PATH)$(PATHSEP)as2ps.cpp $(AS2PS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(AS2PS_PATH)$(PATHSEP)as2ps.cpp

# Make the executable
OBJS = pscript.o as2ps.o 

$(PROJECT):	$(OBJS)
	$(CC) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) $(CPP_FLAG)
# ===============================================================

# ===============================================================
install:
	@echo Installing $(PROJECT) binaries to the bin directory...
	@if exist $(PROJECT).exe copy $(PROJECT).exe $(INSTALL_DIR)
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing COFF file from working directory...
	rm -f $(PROJECT)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT).exe
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
