#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program 
# C/C++ Compiler Used: GNU g++ 2.7.2.1 
# Produced By: Doug Gaer
# File Creation Date: 03/09/1999 
# Date Last Modified: 04/02/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v -- Echo compilation
#       g -- Enable debugging
#       Wall -- Turn on warnings 
#
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = as2htm

# Installation directory for the application and config files
INSTALL_DIR = ../../bin

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
AS2HTM_PATH = .
HTMLDRV_PATH = ../../src

ADD_INC_PATHS = -I../../include

# Setup define macros
DEFMACS = -D__UNIX__

# Define macros for compiler and linker
CC = gcc
CPP = g++ 
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -v -Wall $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS =  

# Build dependency rules
# ===============================================================
HTMLDRV_DEP = ../../include/htmldrv.h

AS2HTM_DEP = ../../include/htmldrv.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

htmldrv.o:	$(HTMLDRV_PATH)$(PATHSEP)htmldrv.cpp $(HTMLDRV_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(HTMLDRV_PATH)$(PATHSEP)htmldrv.cpp

as2htm.o:	$(AS2HTM_PATH)$(PATHSEP)as2htm.cpp $(AS2HTM_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(AS2HTM_PATH)$(PATHSEP)as2htm.cpp

# Make the executable
OBJECTS = htmldrv.o as2htm.o 

$(PROJECT):	$(OBJECTS)
	$(CPP) $(CFLAGS) $(OBJECTS) $(OUTPUT) $(PROJECT) 
# ===============================================================

# Install the binaries and config files to the bin directory
# ===============================================================
install:
	echo Installing $(PROJECT) binaries to the bin directory
	cp $(PROJECT) $(INSTALL_DIR)/. 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)

# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
