#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program 
# C/C++ Compiler Used: DJGPP gcc 2.7.2.1 compiled for MSDOS 
# Produced By: Doug Gaer
# File Creation Date: 03/09/1999 
# Date Last Modified: 03/24/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v -- Echo compilation
#       g -- Enable debugging
#       Wall -- Turn on warnings 
#
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = as2htm

# Installation directory for the application and config files
INSTALL_DIR = ..\..\bin

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
AS2HTM_PATH = .
HTMLDRV_PATH = ../../src

ADD_INC_PATHS = -I../../include

# Setup define macros
DEFMACS = -D__DOS__ 

# Define macros for compiler and linker
CC = gcc
CPP = gcc 
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -Wall $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
CPP_FLAG = -lgpp     
LFLAGS =  

# Build dependency rules
# ===============================================================
HTMLDRV_DEP = ../../include/htmldrv.h

AS2HTM_DEP = ../../include/htmldrv.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

htmldrv.o:	$(HTMLDRV_PATH)$(PATHSEP)htmldrv.cpp $(HTMLDRV_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(HTMLDRV_PATH)$(PATHSEP)htmldrv.cpp

as2htm.o:	$(AS2HTM_PATH)$(PATHSEP)as2htm.cpp $(AS2HTM_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(AS2HTM_PATH)$(PATHSEP)as2htm.cpp

# Make the executable
OBJECTS = htmldrv.o as2htm.o 

$(PROJECT):	$(OBJECTS)
	$(CC) $(CFLAGS) $(OBJECTS) $(OUTPUT) $(PROJECT) $(CPP_FLAG)
# ===============================================================

# ===============================================================
install:
	@echo Installing $(PROJECT) binaries to the bin directory...
	@if exist $(PROJECT).exe copy $(PROJECT).exe $(INSTALL_DIR)
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing COFF file from working directory...
	rm -f $(PROJECT)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT).exe
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
