// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Source Code File Name: vbdref.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/03/1997  
// Date Last Modified: 03/30/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The VBD file statistics functions are used to display detailed
file information about the open file This information is used
to analyze and troubleshoot VBD files. 
*/
// ----------------------------------------------------------- // 
#include "vbdstats.h"

#ifdef __CONSOLE__
#include <iostream.h>
#include <iomanip.h>

void VBDStats(const VBDFilePtr &f)
// Passing VBDFilePtr by reference to avoid calling the Refcount
// copy constructor. This will avoid any unnecessary aliasing.
{
  cout << endl;
  const char *FName = f->VBDFileName();
  char rev_letter = f->GetRevLetter();
  __SBYTE__ FileStatus = f->GetFileStatus(); // Get the current file status
  cout << "----- VBD file statistics -----" << endl;
  cout << endl;
  cout << "----- Static information -----" << endl;
  cout << "File Name:         " << FName << endl;
  cout << "File Signature:    " << f->GetSignature() << endl; 
  if(rev_letter == ' ' || rev_letter == 0)
    cout << "Revision Letter:   " << "None" << endl;
  else
    cout << "Revision Letter:   " << rev_letter << endl;
  cout << "Version Number:    " << f->GetVersion() << endl;
  cout << "File Header Size:  " << f->FileHeaderSize() << endl;
  cout << "Block Header Size: " << f->VBHeaderSize() << endl;
  cout << "Static area size:  " << f->StaticArea() << endl;
  cout << "Static file size:  " << f->FileSize(FName) << endl;
  cout << endl;
  cout << "----- Dynamic Information -----" << endl;
  cout << "File Status:     ";
  if(FileStatus & 0x01) cout << "Good "; else cout << "Bad ";
  if(FileStatus & 0x02) cout << "Open "; else cout << "Closed ";
  if(FileStatus & 0x04) cout << "Read/Write "; else cout << "Read/Only ";
  cout << endl;
  cout << "Free Space:      " << f->GetFreeSpace() << endl;
  cout << "End of File:     " << f->GetEOF() << endl;
  cout << "Heap Start:      " << f->GetHeapStart() << endl;
  cout << "Highest Block:   " << f->GetHighestVB() << endl;
  cout << "Total Blocks:    " << f->VBTotal() << endl;
  unsigned tl, dl, rm;
  tl = f->VBDeleted(&dl, &rm);
  cout << "Deleted/Removed: " << dl << "/" << rm << " (" << tl << ")"
       << endl;
  cout << endl;
}

void VBStats(const VBDFilePtr &f, FAU oa)
// Passing VBDFilePtr by reference to avoid calling the Refcount
// copy constructor. This will avoid any unnecessary aliasing.
{
  VBHeader vb;
  FAU VBAddress = oa - sizeof(VBHeader);
  f->Read(&vb, sizeof(VBHeader), VBAddress);
  char rev_letter = f->GetRevLetter();
  __ULWORD__ object_crc, calc_crc;
  
  cout << endl;
  cout << "----- Block statistics -----" << endl;
  
  cout << "Check Word   = ";
  cout.setf(ios::uppercase);
  cout << "0x" << setfill('0') << setw(8) << hex << vb.CkWord << endl;
  cout.unsetf(ios::uppercase);
  cout << "Length       = " << dec << vb.Length << endl;
  cout << "Status       = " << (__SBYTE__)vb.Status << endl;
  cout << "Next Deleted = " << vb.NextDeletedVB << endl;
  cout << endl;
  cout << "----- Object statistics -----" << endl;
  cout << "Object Length  = " << f->ObjectLength(oa) << endl;

  switch(rev_letter) {
    case 'A':
      f->ReadObjectChecksum(oa, &object_crc, &calc_crc);
      cout.setf(ios::uppercase);
      cout << "Stored CRC     = 0x" << setfill('0') << setw(8) << hex
	   << object_crc << endl;
      cout << "Calculated CRC = 0x" << setfill('0') << setw(8) << hex
	   << calc_crc << dec << endl;
      break;
    
    default: // Default to versions prior to 1027
      break;
  }
  
  cout << endl;
}
#endif // __CONSOLE__

#ifdef __CURSES__
#include "terminal.h"

void VBDStats(Terminal *t, const VBDFilePtr &f)
// Passing VBDFilePtr by reference to avoid calling the Refcount
// copy constructor. This will avoid any unnecessary aliasing.
{
  t->ClearScreen();
  int tab = 5; int ypos = 2;
  const int BUFF_LEN = 255;
  char sbuffer[BUFF_LEN];
  const char *FileName = f->VBDFileName();
  char rev_letter = f->GetRevLetter();
  __SBYTE__ FileStatus = f->GetFileStatus(); // Get the current file status
  char *s1 = "----- Variable Block Database file statistics -----";
  t->Write(s1, t->Center(s1), 0);
  t->Write("----- Static information -----", 0, ypos);
  t->Write("File Name:         ", tab, ++ypos);
  t->Write(FileName);
  t->Write("Signature:         ", tab, ++ypos);
  t->Write(f->GetSignature());
  if(rev_letter == ' ' || rev_letter == 0) {
    t->Write("Revision Letter:   ", tab, ++ypos);
    t->Write("None");
  }
  else {
    t->Write("Revision Letter:   ", tab, ++ypos);
    t->Write(rev_letter);
  }
  t->Write("Version Number:    ", tab, ++ypos);
  t->Write(f->GetVersion());
  t->Write("File Header Size:  ", tab, ++ypos);
  t->Write((int)f->FileHeaderSize());
  t->Write("Block Header Size: ", tab, ++ypos);
  t->Write((int)f->VBHeaderSize());
  t->Write("Static area size:  ", tab, ++ypos);
  t->Write(f->StaticArea());
  ypos++;
  t->Write("----- Dynamic Information -----", 0, ++ypos);
  t->Write("File Status:     ", tab, ++ypos);
  if(FileStatus & 0x01)
    t->Write("Good ");
  else
    t->Write("Bad ");
  if(FileStatus & 0x02)
    t->Write("Open ");
  else
    t->Write("Closed ");
  if(FileStatus & 0x04)
    t->Write("Read/Write ");
  else
    t->Write("Read/Only ");
  t->Write("Free Space:      ", tab, ++ypos);
  t->Write(f->GetFreeSpace());
  t->Write("End of File:     ", tab, ++ypos);
  t->Write(f->GetEOF());
  t->Write("Heap Start:      ", tab, ++ypos);
  t->Write(f->GetHeapStart());
  t->Write("Highest Block:   ", tab, ++ypos);
  t->Write(f->GetHighestVB());
  t->Write("Total Blocks:    ", tab, ++ypos);
  t->Write((int)f->VBTotal());
  unsigned tl, dl, rm; 
  tl = f->VBDeleted(&dl, &rm);
  t->Write("Deleted/Removed: ", tab, ++ypos);
  sprintf(sbuffer, "%u/%u (%u)", dl, rm, tl);
  t->Write(sbuffer);
  ypos += 2;
  t->AnyKey(0, ypos);
  t->ClearScreen();
}
#endif // __CURSES__

#ifdef __wxWIN168B__

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx.h".
#include "wx_prec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx.h"
#endif

void VBDStats(wxTextWindow *textWin, const VBDFilePtr &f)
{
  const char *filename = f->VBDFileName();
  const int BUFF_LEN = 255;
  char sbuffer[BUFF_LEN];
  char rev_letter = f->GetRevLetter();
  __SBYTE__ FileStatus = f->GetFileStatus(); // Get the current file status
  *(textWin) << "\n";
  *(textWin) << "----- Static information -----" << "\n";
  *(textWin) << "File Name: " << (char *)filename << "\n";
  *(textWin) << "Signature: " << (char *)f->GetSignature() << "\n"; 
  if(rev_letter == ' ' || rev_letter == 0)
    *(textWin) << "Revision Letter: " << "None" << "\n";     
  else
    *(textWin) << "Revision Letter: " << rev_letter << "\n";     
  *(textWin) << "Version Number: " << (int)f->GetVersion() << "\n";
  *(textWin) << "File Header Size: " << (int)f->FileHeaderSize() << "\n";
  *(textWin) << "Block Header Size: " << (int)f->VBHeaderSize() << "\n";
  *(textWin) << "Static Area Size: " << f->StaticArea() << "\n";
  *(textWin) << "\n";
  *(textWin) << "----- Dynamic Information -----" << "\n";
  *(textWin) << "File Status: ";
  if(FileStatus & 0x01) *(textWin) << "Good "; else *(textWin) << "Bad ";
  if(FileStatus & 0x02) *(textWin) << "Open "; else *(textWin) << "Closed ";
  if(FileStatus & 0x04)
    *(textWin) << "Read/Write ";
  else
    *(textWin) << "Read/Only ";
  *(textWin) << "\n";
  *(textWin) << "Free Space: " << f->GetVBDFreeSpace() << "\n";
  *(textWin) << "End of File: " << f->GetEOF() << "\n";
  *(textWin) << "Heap Start: " << f->GetHeapStart() << "\n";
  *(textWin) << "Highest Block: " << f->GetHighestVB() << "\n";
  *(textWin) << "Total Blocks: " << (int)f->VBTotal() << "\n";
  unsigned tl, dl, rm;
  tl = f->VBDeleted(&dl, &rm);
  sprintf(sbuffer, "%u/%u (%u)", dl, rm, tl);
  *(textWin) << "Deleted/Removed: " << sbuffer << "\n";
  int tobjects = f->VBTotal() - f->VBDeleted();
  if(tobjects <= 0) tobjects = 0;
  *(textWin) << "Number of objects: " << tobjects << "\n"; 
  *(textWin) << "\n";
}

void VBStats(wxTextWindow *textWin, const VBDFilePtr &f, FAU oa)
{
  VBHeader vb;
  const int BUFF_LEN = 255;
  char sbuffer[BUFF_LEN];
  FAU VBAddress = oa - sizeof(VBHeader);
  f->Read(&vb, sizeof(VBHeader), VBAddress);
  *(textWin) << "----- Block statistics -----" << "\n";
  sprintf(sbuffer, "0x%08X", vb.CkWord);
  *(textWin) << "Check Word: " << sbuffer << "\n";
  *(textWin) << "Length: " << (long)vb.Length << "\n";
  *(textWin) << "Next Deleted: " << vb.NextDeletedVB << "\n";
  *(textWin) << "\n";
  *(textWin) << "----- Object statistics -----" << "\n";
  sprintf(sbuffer, "%d", (vb.Length - sizeof(VBHeader)));
  *(textWin) << "Object Length: " << (long)f->ObjectLength(oa) << "\n";
  *(textWin) << "\n";
}
#endif // __wxWIN168B__

#ifdef __wxWIN201__
#include "wx2incs.h"

void VBDStats(wxTextCtrl *textWin, const VBDFilePtr &f)
{
  const char *filename = f->VBDFileName();
  const int BUFF_LEN = 255;
  char sbuffer[BUFF_LEN];
  char rev_letter = f->GetRevLetter();
  __SBYTE__ FileStatus = f->GetFileStatus(); // Get the current file status
  *(textWin) << "\n";
  *(textWin) << "----- Static information -----" << "\n";
  *(textWin) << "File Name: " << (char *)filename << "\n";
  *(textWin) << "Signature: " << (char *)f->GetSignature() << "\n"; 
  if(rev_letter == ' ' || rev_letter == 0)
    *(textWin) << "Revision Letter: " << "None" << "\n";     
  else
    *(textWin) << "Revision Letter: " << rev_letter << "\n";     
  *(textWin) << "Version Number: " << (int)f->GetVersion() << "\n";
  *(textWin) << "File Header Size: " << (int)f->FileHeaderSize() << "\n";
  *(textWin) << "Block Header Size: " << (int)f->VBHeaderSize() << "\n";
  *(textWin) << "Static Area Size: " << f->StaticArea() << "\n";
  *(textWin) << "\n";
  *(textWin) << "----- Dynamic Information -----" << "\n";
  *(textWin) << "File Status: ";
  if(FileStatus & 0x01) *(textWin) << "Good "; else *(textWin) << "Bad ";
  if(FileStatus & 0x02) *(textWin) << "Open "; else *(textWin) << "Closed ";
  if(FileStatus & 0x04)
    *(textWin) << "Read/Write ";
  else
    *(textWin) << "Read/Only ";
  *(textWin) << "\n";
  *(textWin) << "Free Space: " << f->GetVBDFreeSpace() << "\n";
  *(textWin) << "End of File: " << f->GetEOF() << "\n";
  *(textWin) << "Heap Start: " << f->GetHeapStart() << "\n";
  *(textWin) << "Highest Block: " << f->GetHighestVB() << "\n";
  *(textWin) << "Total Blocks: " << (int)f->VBTotal() << "\n";
  unsigned tl, dl, rm;
  tl = f->VBDeleted(&dl, &rm);
  sprintf(sbuffer, "%u/%u (%u)", dl, rm, tl);
  *(textWin) << "Deleted/Removed: " << sbuffer << "\n";
  int tobjects = f->VBTotal() - f->VBDeleted();
  if(tobjects <= 0) tobjects = 0;
  *(textWin) << "Number of objects: " << tobjects << "\n"; 
  *(textWin) << "\n";
}

void VBStats(wxTextCtrl *textWin, const VBDFilePtr &f, FAU oa)
{
  VBHeader vb;
  const int BUFF_LEN = 255;
  char sbuffer[BUFF_LEN];
  FAU VBAddress = oa - sizeof(VBHeader);
  f->Read(&vb, sizeof(VBHeader), VBAddress);
  *(textWin) << "----- Block statistics -----" << "\n";
  sprintf(sbuffer, "0x%08X", vb.CkWord);
  *(textWin) << "Check Word: " << sbuffer << "\n";
  *(textWin) << "Length: " << (long)vb.Length << "\n";
  *(textWin) << "Next Deleted: " << vb.NextDeletedVB << "\n";
  *(textWin) << "\n";
  *(textWin) << "----- Object statistics -----" << "\n";
  sprintf(sbuffer, "%d", (vb.Length - sizeof(VBHeader)));
  *(textWin) << "Object Length: " << (long)f->ObjectLength(oa) << "\n";
  *(textWin) << "\n";
}
#endif // __wxWIN201__

// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
