// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: strutil.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 12/16/1997 
// Date Last Modified: 03/30/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

General string utility functions use to manipulate and parse
null-terminated character strings.
*/
// ----------------------------------------------------------- // 
#include <string.h>
#include <ctype.h>
#include "strutil.h"

// This include file is no longer used
// #include "os_type.h"

// Enable this macro DOS and Windows applications
// #ifndef __DOS__
// #define __DOS__
// #endif 

// Enable this macro for Generic Unix applications
// #ifndef __UNIX__
// #define __UNIX__
// #endif 

char *StringCat(const char *s1, const char *s2, const char *s3)
{
  int len = strlen(s1) + strlen(s2) + strlen(s3);
  char *comp = new char[len];
  comp[len] = '\0';
  strcpy(comp, s1);
  strcat(comp, s2);
  strcat(comp, s3);
  return comp;
}

char *StringCat(char *s1, char *s2, char *s3)
{
  int len = strlen(s1) + strlen(s2) + strlen(s3);
  char *comp = new char[len];
  comp[len] = '\0';
  strcpy(comp, s1);
  strcat(comp, s2);
  strcat(comp, s3);
  return comp;
}

int parse(char *string, char words[MAXWORDS][MAXWORDLENGTH],
	  int*numwords, char sepchar)
// General purpose string parser
{
  int i = 0;
  char newword[MAXWORDLENGTH];
  *numwords = 0;

  // First skip over leading blanks. Stop if an ASCII NULL is seen
  while (1) {
    if (*string == '\0') return 0;
    if (*string != ' ') break;
    string++;
  }
  
  while(1) {
    // Check to see if there is room for another word in the array
    if(*numwords == MAXWORDS) return 1;

    i = 0;
    while (i < MAXWORDLENGTH) {
      if(*string == 0 || *string == sepchar) break;
      newword[i] = *string;
      string++;
      i++;
    }
    newword[i] = 0;   // Ensure an ASCII null at end of newword. 
    strcpy (words[*numwords], newword);  // Install into array 
    (*numwords)++;
    
    // If stopped by an ASCII NULL above, exit loop
    if(*string == 0) break;
    
    string++;
    if(*string == 0) break;
  }
  return 0;
}

int CaseICmp(const char *s1, const char *s2)
// Compare two strings without regard to the case of the letters
{
#if defined (__DOS__) 
  // Case-insensitive compare for most DOS/Windows Compilers
  return stricmp(s1, s2);
#elif defined(__VISUALC__) || ( defined(__MWERKS__) && defined(__INTEL__) )
  return stricmp(s1, s2);
#elif defined(__SC__)
  return stricmp(s1, s2);
#elif defined(__SALFORDC__)
  return stricmp(s1, s2);
#elif defined(__BORLANDC__)
  return stricmp(s1, s2);
#elif defined(__WATCOMC__)
  return stricmp(s1, s2);
#elif defined (__UNIX__) || defined(__GNUWIN32__)
  // Case-insensitive compare for most UNIX Compilers
  return strcasecmp(s1, s2);
#else
    register char c1, c2;
    do {
      c1 = tolower(*s1++);
      c2 = tolower(*s2++);
    } while ( c1 && (c1 == c2) );

    return c1 - c2;
#endif 
}

int CaseICmp(char *s1, char *s2)
// Compare two strings without regard to the case of the letters
{
#if defined (__DOS__) 
  // Case-insensitive compare for most DOS/Windows Compilers
  return stricmp(s1, s2);
#elif defined(__VISUALC__) || ( defined(__MWERKS__) && defined(__INTEL__) )
  return stricmp(s1, s2);
#elif defined(__SC__)
  return stricmp(s1, s2);
#elif defined(__SALFORDC__)
  return stricmp(s1, s2);
#elif defined(__BORLANDC__)
  return stricmp(s1, s2);
#elif defined(__WATCOMC__)
  return stricmp(s1, s2);
#elif defined (__UNIX__) || defined(__GNUWIN32__)
  // Case-insensitive compare for most UNIX Compilers
  return strcasecmp(s1, s2);
#else
    register char c1, c2;
    do {
      c1 = tolower(*s1++);
      c2 = tolower(*s2++);
    } while ( c1 && (c1 == c2) );

    return c1 - c2;
#endif 
}

int FindMatch(const char *str, const char *p, unsigned offset)
// Finds pattern "p" in string "s" starting at specified offset.
// Returns index of first occurrence of matching pattern or -1
// if no match is found.
{
  char *Start = (char *)str + offset; // Start of string data
  char *Next = Start;                 // Next string element
  char *Pattern = (char *)p;          // Next pattern element
  unsigned i = offset;                // Next string element index
  unsigned Len = strlen(str);
  
  while(i < Len && *Pattern) {
    if (*Next == *Pattern) {
      Pattern++;
      if(*Pattern == 0) return i; // Pattern was found
      Next++;
    }
    else {
      i++;
      Start++;
      Next = Start;
      Pattern = (char *)p;
    }
  }
  return NOMATCH; // No match was found
}

int FindMatch(char *str, char *p, unsigned offset)
// Finds pattern "p" in string "s" starting at specified offset.
// Returns index of first occurrence of matching pattern or -1
// if no match is found.
{
  return FindMatch((const char *)str, (const char *)p, offset);
}

int IFindMatch(const char *str, const char *p, unsigned offset)
// Finds pattern "p" in string "s" starting at specified offset
// using a case insensitive compare. Returns index of first 
// occurrence of matching pattern or -1 if no match is found.
{
  char *Start = (char *)str + offset; // Start of string data
  char *Next = Start;                 // Next string element
  char *Pattern = (char *)p;          // Next pattern element
  unsigned i = offset;                // Next string element index
  unsigned Len = strlen(str);
  
  while(i < Len && *Pattern) {
    if (tolower(*Next) == tolower(*Pattern)) {
      Pattern++;
      if(*Pattern == 0) return i; // Pattern was found
      Next++;
    }
    else {
      i++;
      Start++;
      Next = Start;
      Pattern = (char *)p;
    }
  }
  return NOMATCH; // No match was found
}

int IFindMatch(char *str, char *p, unsigned offset)
// Finds pattern "p" in string "s" starting at specified offset
// using a case insensitive compare. Returns index of first 
// occurrence of matching pattern or -1 if no match is found.
{
  return IFindMatch((const char *)str, (const char *)p, offset);
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
