// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: sbllist.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 12/29/1996  
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

Base classes for singly linked list implementations. The
SNodeBase class and the SDLListBase class separates the
nodes from the data stored in the list by storing pointers
to the data. Classes derived from these base classes can
deal with any type of node data.
*/
// ----------------------------------------------------------- // 
#include "sllistb.h"

SLListBase::~SLListBase()
{
  // Destructor provided for virtuality
}

void SLListBase::MakeEmpty()
{
  SelfRef();
  Back = this;
}

void SNodeBase::InsertAfter(SNodeBase *Node)
{
  Node->Next = Next;
  Next = Node;
}

SNodeBase *SNodeBase::RmvNext()
{
  SNodeBase *ptr = Next;
  Next = ptr->Next;
  return ptr;
}

void SLListBase::Clear()
{
  SNodeBase *Node = Next;
  while(!IsHeader(Node)) {
    SNodeBase *NextNode = Node->Next;
    FreeNode(Node); // Must be defined in derived  classes
    Node = NextNode;
  }
  MakeEmpty();
}

SNodeBase *SLListBase::RmvNext(SNodeBase *Node)
{
  if(Node->Next == this) return 0; // Return null if Node is the header
  SNodeBase *ptr = Node->RmvNext();
  if(ptr == Back) Back = Node;
  return ptr; // Remove and return Node pointer
}

int SLListBase::Copy(const SLListBase &List)
{
  if(&List == this) return 1; // Already its own copy
  Clear(); // Clear current nodes from this list
  return Cat(List); // 1 if successful, 0 if fails
}

int SLListBase::Cat(const SLListBase &List)
{
  if(this == &List) return 0; // Do not append list onto itself
  const SNodeBase *ptr = List.Next;
  while(!List.IsHeader(ptr)) { // For all nodes in List
    SNodeBase *Node = DupNode(ptr);
    if(Node == 0) return 0; // Incomplete copy made
    AttachToBack(Node);
    ptr = ptr->Next;
  }
  return 1; // Successful concatenation
}    
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
