// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: entrykey.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/12/1997 
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The EntryKey class is used to identify objects in the database
by a unique key name when an index file is used. Each key is
fixed in length by the MAXKEYSIZE constant. An (E)ntry (K)ey
is a key, along with its associated data address and branch
fields.

The Multi-way node (E)ntryKey class and (M)ulti-way (n)ode
classes are used to make up (B)alanced multi-way (T)rees.
Each node in the tree will have a left branch that leads to
all nodes with keys smaller than the smallest key. The right
branches will be paried with a key, each branch leading to all
nodes with keys greater than the given key, but less than the
key to the right. 
*/
// ----------------------------------------------------------- // 
#include <string.h>
#include "strutil.h"
#include "entrykey.h"

EntryKey::EntryKey()
{
  // Set all the bytes of the entry key to zero
  for(int i = 0; i < MAXKEYSIZE; i++) key[i] = 0;
}

EntryKey::EntryKey(const EntryKey &s)
{
  for(int i = 0; i < MAXKEYSIZE; i++) key[i] = 0;
  strcpy(key, s.key);
  object_address = s.object_address;
  class_id = s.class_id;
  right = s.right;
}

EntryKey::EntryKey(const char *s)
{
  for(int i = 0; i < MAXKEYSIZE; i++) key[i] = 0;
  strncpy(key, s, MAXKEYSIZE); key[MAXKEYSIZE-1] = 0;
  object_address = 0; class_id = 0; right = 0; 
}

EntryKey::EntryKey(const char *s, INT32 oa, INT32 ci)
{
  for(int i = 0; i < MAXKEYSIZE; i++) key[i] = 0;
  strncpy(key, s, MAXKEYSIZE); key[MAXKEYSIZE-1] = 0;
  right = 0;
  object_address = oa;
  class_id = ci;
}

void EntryKey::operator=(const EntryKey &s)
{
  if (this == &s) return;
  for(int i = 0; i < MAXKEYSIZE; i++) key[i] = 0;
  strcpy(key, s.key);
  right = s.right;
  object_address = s.object_address;
  class_id = s.class_id;
}

void EntryKey::operator=(const char *s)
// Assigns the key portion, but no other fields
{
  for(int i = 0; i < MAXKEYSIZE; i++) key[i] = 0;
  strncpy(key, s, MAXKEYSIZE); key[MAXKEYSIZE-1] = 0;
}

int Compare(const EntryKey &a, const EntryKey &b)
// Friend function that does a partial compare of a and b.
// Compares only the key string, not the data.
// Returns -1 if a < b, 0 if a == b, or 1 if a > b.
{
  // 02/10/1999: Modified to perform a case-insensitive comparison
  // on the key member to prevent duplicate entries from appearing
  // in the B-tree when objects are identified by their key name only.
  return CaseICmp(a.key, b.key);
}

int FullCompare(const EntryKey &a, const EntryKey &b)
// Friend function that does a full compare of a and b.
// Compares the key string as well as the data fields.
// Returns -1 if a < b, 0 if a == b, or 1 if a > b.
{
  // 02/10/1999: Modified to perform a case-insensitive comparison
  // on the key member to keep the B-tree entries in alphabetical
  // order during insertions. As long Each object in the data file 
  // is uniquely indentified by its address the case of the object's 
  // key name is irrelevant during a full compare.
  int rv = CaseICmp(a.key, b.key);
  if (rv < 0) return -1;
  if (rv > 0) return 1;
  if (a.object_address > b.object_address) return 1;
  if (a.object_address < b.object_address) return -1;
  if (a.class_id > b.class_id) return 1;
  if (a.class_id < b.class_id) return -1;
  return 0;
}

void EntryKey::SetStrKey(char *s)
{
  strncpy(key, s, MAXKEYSIZE);
  key[MAXKEYSIZE-1] = 0; // Ensure null termination
}  

void EntryKey::SetStrKey(const char *s)
{
  strncpy(key, s, MAXKEYSIZE);
  key[MAXKEYSIZE-1] = 0; // Ensure null termination
}  
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
