// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: config.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer  
// File Creation Date: 02/19/1996 
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The Config class is a character string based singly linked list
that is used to load program parameters from a ASCII text based
configuration file.
*/
// ----------------------------------------------------------- // 
#include <stdlib.h>
#include <fstream.h>
#include <string.h>
#include <ctype.h>
#include "config.h"

Config::~Config()
{
  UnLoad();
}

void Config::UnLoad()
{
  Clear();
}         

int Config::Load(char *Fname)
{
  const int MaxLine = 512;
  char LineBuffer[MaxLine];
  char *buf;
  int Status;
  
  // Open Config file
  ifstream InFile(Fname, ios::in|ios::nocreate);
  if(!InFile) return 0; 
        
  while(!InFile.eof())
  {
    // Read in config file line by line
    InFile.getline(LineBuffer, MaxLine);

    // Allocate memory for temporary holding buffer
    buf = new char[strlen(LineBuffer)+1];
    if(!buf) return 0;
    
    // Copy contents of the array to temporary holding buffer
    strcpy(buf, LineBuffer);

    // Load config file data into singly-linked list
    Status = StoreCfgData(buf);
    if(!Status) return 0;
  }

  InFile.close();
  delete[] buf;
  return 1; // Indicates success
}

int Config::StoreCfgData(char *str)
{
  ConfigData *ptr = new ConfigData;
  ChSNode *chsptr;
 
  // Look for alphanumeric lines containing an equal sign
 if (isalnum(str[0]) && strchr(str, '='))
 {
   ptr->Name = str;
   
   chsptr = Store(ptr->Name); // Store the parameter name
   if(!chsptr) return 0;
   
   // Copy config file parameter value into memory
   ptr->Value = strchr(str, '='); // Strip off parameter name
   *ptr->Value++ = '\0';          // Strip off equal sign

   chsptr = Store(ptr->Value); // Store the config value
   if(!chsptr) return 0;
 }

 delete ptr;
 return 1; // Indicate success
}

char* Config::GetStrValue(char *Name)
{
  ChSNode *ptr;

  ptr = Find(Name);
  if(ptr) return ptr->GetNext()->Data;  // Return config value

  //Return NULL if config value is not found
  return 0;
}

int Config::GetIntValue(char *Name)
{
  ChSNode *ptr;

  ptr = Find(Name);
  if(ptr) return atoi(ptr->GetNext()->Data); // Return config value

  //Return NULL if config value is not found
  return 0;
}

double Config::GetDFPValue(char *Name)
{
  ChSNode *ptr;

  ptr = Find(Name);
  if(ptr) return atof(ptr->GetNext()->Data); // Return config value

  //Return NULL if config value is not found
  return 0;
}

long Config::GetLongValue(char *Name)
{
  ChSNode *ptr;

  ptr = Find(Name);
  if(ptr) return atol(ptr->GetNext()->Data); // Return config value

  //Return NULL if config value is not found
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
