// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: chptrb.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/07/1997  
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The CachePtrb class is used as a data indepentent base class for
the CachePtr class. Cache pointers are used to work in conjunction
with the reference counted cache buckets. Each cache pointer stores
the file address of the object being poined to, a pointer to the
bucket containing the memory buffer of the object, and a pointer
to the cache the cache pointer is connected to.
*/
// ----------------------------------------------------------- // 
#include "chptrb.h"
#include "bucket.h"
#include "cacheb.h"

CachePtrb::CachePtrb(Cacheb &c, FAU p)
// General cache pointer constructor. Note that a cache
// is required. The cache pointer stays unbound untill needed.
{
  cache = &c; Address = p; bound = 0; bkt = 0;
}

CachePtrb::CachePtrb(const CachePtrb &c)
// Copy constructor. Note that destination cache pointer
// will not be bound until needed, even if source is bound.
{
  Address = c.Address; bkt = c.bkt; cache = c.cache; bound = 0;
}

Bucketb *CachePtrb::Alloc(size_t n, FAU p)
// Allocates n bytes of room (presumably the size of the
// data in the bucket) at address p in the cache's
// file, and sets up a cache bucket to support it.
// If p != 0, it means the room has already been allocated.
// Note that ReserveBkt will setup bucket's address,
// cache pointer and refcnt, but doesn't load any data.
// Returns a pointer to the bucket, or 0 if couldn't
// allocate.
{
  Release(); // Let go of any currently bound data
  if (p == 0) p = cache->fptr->Alloc(n);
  bkt = cache->ReserveBkt(p, 0);
  if (bkt) {
     bkt->SetDirty(); // Data modified by constructor
     Address = p;
     bound = 1;
  }
  else {
     Address = 0; // bound will = 0 here as well
  }
  return bkt;
}

void CachePtrb::Delete(unsigned n)
// Deallocates the file data pointed to by this cache pointer, 
// of size n. Deallocation only takes place if this cache pointer is
// pointing to a bucket bound by no one else. Cache pointer is unbound
// afterwards and both the bucket and cache pointer are made null.
{
  if (bound && bkt->IsLocked() == 1 ||
      !bound && (!bkt || !bkt->IsLocked())) {
     cache->fptr->Remove(Address);
     Release();
     bkt->MakeNull();
     Address = 0;
  }
  else
#ifdef CPP_EXCEPTIONS
    throw CDanglingPtr();
#else
    Error->SignalException(EHandler::DanglingPtr);
#endif
}

void CachePtrb::Copy(const CachePtrb &c)
// Copies one cache pointer into another. Note that the destination
// cache pointer isn't bound, even if the source cache pointer is.
{
  Release();  
  Address = c.Address;
  bkt = c.bkt;
  bound = 0;
  cache = c.cache;
}

void CachePtrb::Bind()
// Binds the cache pointer to a bucket containing data stored at
// file location address. Note that it may already be pointing
// to the correct bucket. Assumes bucket is not already bound.
{
  
  if (bkt && bkt->Address == Address) { // Fast binding
    if (Address) {
      bkt->Lock();
      cache->FastBind();
      bound = 1;
    }
    else
#ifdef CPP_EXCEPTIONS
      throw CNullPtr();
#else
      Error->SignalException(EHandler::NullPtr);
#endif
  }
  else {
    bkt = cache->ReserveBkt(Address, 1);
    if (bkt)
      bound = 1;
    else
#ifdef CPP_EXCEPTIONS
      throw CNullPtr();
#else
      Error->SignalException(EHandler::NullPtr);
#endif
  }
}

void CachePtrb::Release()
// Signal to the bucket that it is through with it.
{
  if (bound) {
     bkt->Unlock();
     bound = 0;
  }
}

void CachePtrb::NotifyUseOf()
// Moves the referenced bucket to the front of the
// cache queue. For cache performance tuning.
{
  if (bound) cache->MoveToFront(bkt);
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
