// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Source Code File Name: chlist.cpp
// C++ Compiler Used: Microsoft Visual C/C++ 4.2  
// Produced By: Doug Gaer
// File Creation Date: 12/29/1996
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

A character string doubly linked list class derived from the
DNodeBase class and the DLListBase class.
*/
// ----------------------------------------------------------- //   
#include <string.h>
#include "chlist.h"

ChList::~ChList()
{
  Clear();
}

int ChList::Copy(const ChList &List)
{
  return DLListBase::Copy(List);
}

ChNode *ChList::AllocNode(const DLTYPE &X)
{
  return new ChNode(X);
}

DNodeBase *ChList::DupNode(const DNodeBase *Node)
{
  return AllocNode(((ChNode *)Node)->Data);
}

void ChList::FreeNode(DNodeBase *Node)
{
  delete((ChNode *)Node);
}

const ChNode *ChList::Find(const DLTYPE &X, const ChNode *ptr) const
// Returns the first node having an element that matched X
{
  if(ptr == 0) ptr = GetFront();

  while(!IsHeader(ptr)) { // Scan until end of list
    if(strcmp(ptr->Data, X) == 0) return ptr; // Match found
    ptr = ptr->GetNext();
  }
  return 0; // No match
}

ChNode *ChList::Find(const DLTYPE &X, ChNode *ptr)
// Returns the first node having an element that matched X
{
  if(ptr == 0) ptr = GetFront();

  while(!IsHeader(ptr)) { // Scan until end of list
    if(strcmp(ptr->Data, X) == 0) return ptr; // Match found
    ptr = ptr->GetNext();
  }
  return 0; // No match
}

int ChList::Delete(ChNode *Node, DLTYPE *X)
{
  ChNode  *ptr = Rmv(Node);
  if(ptr) {
    if(X) *X = ptr->Data; // Copy Data into X if X != 0
    FreeNode(ptr);
    return 1; // Return 1 if successful
  }
  return 0; 
}

int ChList::DeleteFront(DLTYPE *X)
{
  ChNode  *ptr = RmvFront();
  if(ptr) {
    if(X) *X = ptr->Data; // Copy Data into X if X != 0
    FreeNode(ptr);
    return 1; // Return 1 if successful
  }
  return 0; 
}

int ChList::DeleteBack(DLTYPE *X)
{
  ChNode  *ptr = RmvBack();
  if(ptr) {
    if(X) *X = ptr->Data; // Copy Data into X if X != 0
    FreeNode(ptr);
    return 1; // Return 1 if successful
  }
  return 0; 
}

ChNode *ChList::Store(const DLTYPE &X)
{
  ChNode  *ptr = AllocNode(X);
  if(ptr) AttachToBack(ptr);
  return ptr; // Return a pointer to the node added
}

ChNode *ChList::AddToFront(const DLTYPE &X)
{
  ChNode  *ptr = AllocNode(X);
  if(ptr) AttachToFront(ptr);
  return ptr; // Return a pointer to the node added
}

ChNode *ChList::AddToBack(const DLTYPE &X)
{
  ChNode  *ptr = AllocNode(X);
  if(ptr) AttachToBack(ptr);
  return ptr; // Return a pointer to the node added
}

ChNode *ChList::AddBefore(const DLTYPE &X, ChNode *Node)
{
  ChNode  *ptr = AllocNode(X);
  if(ptr) InsertBefore(Node, ptr);
  return ptr; // Return a pointer to the node added
}

ChNode *ChList::AddAfter(const DLTYPE &X, ChNode *Node)
{
  ChNode *ptr = AllocNode(X);
  if(ptr) InsertAfter(Node, ptr);
  return ptr; // Return a pointer to the node added
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

