// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: cacstats.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/07/1997  
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

Cache printing functions used to display performance statistics.
*/
// ----------------------------------------------------------- // 
#include <iostream.h> 
#include <iomanip.h>  
#include "cacstats.h"
#include "bucketb.h"

void Report(Cacheb &c, int full_report) // Test purposes only
// Reports on the status of the cache.
{
  Bucketb *b = c.GetHead();
  int cnt = 0, i = 0;
  do {
    if (b->IsLocked()) cnt++;
    if (full_report) {
       cout << "Bucket[" << setfill('0') << setw(3) << i << "]: ";
       cout << "Address = " << setfill('0') << setw(3)
	    << b->GetAddress() << ' ';
       cout << "Refs = " << b->GetRefCnt() << ' ';
       cout << "Dirty = " << int(b->GetDirty()) << endl;
    }
    i++; b = b->GetNext();
  } while(b != c.GetHead());

  cout << endl;
  cout << "FAST BINDS - binds to previously allocated, unchanged buckets."
       << endl;
  cout << "HITS - number of buckets that did not have to be acqiured."
       << endl;
  cout << "MISSES - number of cache buckets that had to be acqiured."
       << endl;
  cout << endl;
  float ratio = 0.0;
  if (c.GetHits() + c.GetFastBinds())
     ratio = ((float)(c.GetHits()+c.GetFastBinds()) / 
	      (float)(c.GetHits()+c.GetFastBinds()+c.GetMisses()) ) * 100.0;
  cout << "Fast binds/hits/misses: "
       << c.GetFastBinds() << " / " << c.GetHits() << " / " << c.GetMisses()
       << " (" << setprecision(2) << ratio << "%)" << endl;
  cout << endl;
  cout << "Reservations (HITS + FAST BINDS + MISSES): "
       << (c.GetHits() + c.GetFastBinds() + c.GetMisses()) << endl;
  cout << endl;
  cout << "Number of buckets allocated: " << c.GetBuckets() << endl;
  cout << endl;
  cout << "Number of buckets currently locked: " << cnt << endl;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
