// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: cache.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer  
// File Creation Date: 02/07/1997  
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The Cache class is derived from the Cacheb class. It adds two
functions to handle the allocation and de-allocation of buckets.
The cache is used to handle requests for file-based objects. The
cache must determine whether an object is already loaded. If the
object is not loaded the cache reserves a bucket and loads the
object into memory. This cache design uses cache pointers to
reference cache buckets directly, with each cache pointer being
initialized after the bucket is reserved. The least-recently
reserved cache bucket is overwritten when the cache fills up.
*/
// ----------------------------------------------------------- //   

#ifdef __NOT_USING_TEMPLATE_CLASS__
#include "cache.h"

Cache::Cache(int n) : Cacheb(buckets = new Bucket[n], n, sizeof(Bucket))
// Buckets are stored in an array and organized as a circular doubly-linked
// list by the Cacheb class.
{

}

Cache::~Cache()
{
  if (fptr) Flush(); Disconnect();
  delete[] buckets;
}
#endif //  __NOT_USING_TEMPLATE_CLASS__

// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
