// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: btwalk.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 02/12/1997 
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The BtreeWalk() function defines a generic iterator used to walk
through Balanced multi-way file-base tree class.
*/
// ----------------------------------------------------------- // 
#include "btwalk.h"

InMemCopy::InMemCopy(char *k, INT32 oa, INT32 cid) {
  int len = strlen(k);
  UString buf(k, len); // Allocate the minimum amount needed
  key = buf;
  object_address = oa;
  class_id = cid;
}

InMemCopy::InMemCopy(const InMemCopy &ob) {
  key = ob.key;
  object_address = ob.object_address;
  class_id = ob.class_id;
}

void InMemCopy::operator=(const InMemCopy &ob) { 
  key = ob.key;
  object_address = ob.object_address;
  class_id = ob.class_id;
}

int Compare(const InMemCopy &a, const InMemCopy &b)
// Friend function that compares the key, address, and id members.
// Returns -1 if a < b, 0 if a == b, or 1 if a > b.
{
   int rv = CaseICmp(a.key.c_str(), b.key.c_str());
   if (rv > 0) return 1;
   if (rv < 0) return -1;
   if (a.object_address > b.object_address) return 1;
   if (a.object_address < b.object_address) return -1;
   if (a.class_id > b.class_id) return 1;
   if (a.class_id < b.class_id) return -1;
   return 0;
}

void BtreeWalk(CachePointer t, BtreeVisitFunc Visit, Btree *tree)
// This is a recursive function used to walk through
// the btree node by node.
{
  int i;

  // Ensure that the in memory buffers and the file data
  // stay in sync during multiple file access.
  if(tree) tree->TestTree();

  if ((__LWORD__)t) {
    (*Visit)(t); // Process the node data
    int n = t->cnt;
    CachePointer p(t);

    for(i = -1; i < n; i++) {
      p = t->Branch(i);
      t.Release();
        BtreeWalk(p, Visit);  
    }
  }
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
