// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: asprint.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer  
// File Creation Date: 09/18/1997  
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

These classes and functions are used to print data to ASCII
text files and format data for various print functions.
*/
// ----------------------------------------------------------- // 
#include "asprint.h"
#include <stdio.h>
#include <string.h>

void ASPrint(const char *s, ostream &stream, int offset, int pos,
	     const char pad)
// Prints a null terminated string to the stream starting at the
// specified position or the current position if the pos variable
// equals zero. The offset variable specifies the number of character
// to pad after the text is printed.
{
  int i = 0;
  int len = strlen(s);
  char *buf = new char[len+1];
  buf[len] = '\0';
  strcpy(buf, s);
  if(len > offset) len = offset-1; // Subtract 1 to avoid overlaps
  if(pos) for(i = 0; i < pos; i++) stream << pad; // Position the text
  for(i = 0; i < len; i++) stream << buf[i];
  if(len < offset) {
    offset = offset - len;
    for(i = 0; i < offset; i++) stream << pad;
  }
  delete[] buf;
}

void ASPrint(const char *s, const char filter, ostream &stream, int offset,
	     int pos, const char pad)
// Prints a null terminated string to the stream starting and filters
// any unwanted characters specifed by the filter variable.
{
  int i = 0;
  int len = strlen(s);
  char *buf = new char[len+1];
  buf[len] = '\0';
  strcpy(buf, s);
  if(len > offset) len = offset-1; // Subtract 1 to avoid overlaps
  if(pos) for(i = 0; i < pos; i++) stream << pad; // Position the text
  for(i = 0; i < len; i++) {
    // Filter all unwanted characters
    if(buf[i] != filter) stream << buf[i];
  }
  if(len < offset) {
    offset = offset - len;
    for(i = 0; i < offset; i++) stream << pad;
  }
  delete[] buf;
}

void ASPrint(const char c, ostream &stream, int offset, int pos,
	     const char pad)
// Prints a single character to the stream starting.
{
  char s[1];
  s[0] = c;    // Copy char into a string buffer
  s[1] = '\0'; // Null terminate the string
  ASPrint(s, stream, offset, pos, pad);
}
  
void ASPrint(int val, ostream &stream, int offset, int pos, const char pad)
{
  char *buf = new char[offset+1];
  buf[offset] = '\0';
  sprintf(buf, "%d", val);
  ASPrint(buf, stream, offset, pos, pad);
  delete[] buf; 
}

void ASPrint(long val, ostream &stream, int offset, int pos, const char pad)
{
  char *buf = new char[offset+1];
  buf[offset] = '\0';
  sprintf(buf, "%d", val);
  ASPrint(buf, stream, offset, pos, pad);
  delete[] buf; 
}

void ASPrint(double val, ostream &stream, int offset, int pos, const char pad)
{
  char *buf = new char[offset+1];
  buf[offset] = '\0';
  sprintf(buf, "%g", val);
  ASPrint(buf, stream, offset, pos, pad);
  delete[] buf; 
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
