// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbdref.h
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/03/1997  
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

Reference counting is a technique used to ensure the safe
deletion or modification of an object when a copy of the
object exists. In order to create reference counted objects,
a class must inherit the CountedObject class to embed a
reference count into each object. The vbdRefCount class is
used to handle pointers to reference counted objects. It
works by storing pointers to objects in containers, rather
than the objects themselves. 

NOTE: This class is also implemented as template class
named RefCount. To avoid portablity problems with HPUX CPP
it was renamed and coded directly for VBDFile class objects.

The template implementation named RefCount caused a linker
error when compling under HPUX 10.20 (using HPUX CPP 1024)
in some wxWindows applications.
*/
// ----------------------------------------------------------- //
#ifndef __VDBREFCOUNT_HPP__
#define __VBDREFCOUNT_HPP__

#include "refcount.h" // Need for the CountedObject class

#ifdef __NOT_USING_TEMPLATE_CLASS__

class VBDFile; // Forward the class calling convention

// (R)eference (C)ount class
// The RefCount class is used to handle reference-counted objects.
// Reference counted pointers work like normal pointers, except
// they keep track of the number of references to the objects they
// point to. To set up a reference counted pointer to an object,
// allocate and initialize the object on the heap using the new
// operator, and then pass a pointer to the object in a call to
// the RefCount constructor.
class vbdRefCount
{
public:
  vbdRefCount(VBDFile *ptr = 0) { ObjectPtr = ptr; }
  ~vbdRefCount() { Unbind(); }
  vbdRefCount(const vbdRefCount &ptr) { // Copy constructor
    // Called when a RefCount pointer is passed by value or copied.
    // Like normal pointers only the ObjectPtr is copied, not the
    // object pointed to by ObjectPtr. The aliasing that ocurrs at
    // this point is recorded by incrementing the reference count.
    Bind(ptr);
  }
    
  void operator=(const vbdRefCount &ptr) {
    // Assignment operator using share semantics.
    // This assignment operator does not allow chain assignments
    NewBinding(ptr);
  }
  
  // int is a dummy parameter used to set the pointer to a NULL
  void operator=(int) { Unbind(); ObjectPtr = 0; }

protected:
  void Bind(const vbdRefCount &ptr);
  void Unbind();
  void NewBinding(const vbdRefCount &ptr);

protected:
  // VBDFile assumed to be a structure having IncRefCount(),
  // DecRefCount(), and Referenced() member functions inherited
  // from the CountedObject class.
  VBDFile *ObjectPtr;

public:
  // The overloaded * and -> operators allow reference
  // counted pointers to be de-referenced like ordinary pointers.
  VBDFile &operator*() const { return *ObjectPtr; } 
  VBDFile *operator->() const { return ObjectPtr; }

  // Used to test whether a RefCount is null
  int operator!() { return ObjectPtr == 0; } // True if equal 0
  operator int() { return ObjectPtr != 0; }  // True if not equal 0
  
  friend int operator==(const vbdRefCount &a, const vbdRefCount &b)
  {
    return a.ObjectPtr == b.ObjectPtr;
  }
  
  friend int operator!=(const vbdRefCount &a, const vbdRefCount &b)
  {
    return a.ObjectPtr != b.ObjectPtr;
  }
};
#endif // __NOT_USING_TEMPLATE_CLASS__


#endif // __VBDREFCOUNT_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
